/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.aksw.jena_sparql_api.core.SparqlService;
import org.aksw.jena_sparql_api.core.SparqlServiceFactory;
import org.aksw.jena_sparql_api.sparql.ext.http.HttpInterceptorRdfLogging;
import org.aksw.jena_sparql_api.update.DatasetListenerTrack;
import org.aksw.jena_sparql_api.update.SinkModelWriter;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.riot.web.HttpOp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class ConfigSparqlServicesCore {
    private Random random = new Random();

    @Bean
    @Autowired
    @Primary
    public SparqlServiceFactory workflowSparqlServiceFactory(@Qualifier(value="config") SparqlServiceFactory ssf, @Qualifier(value="tracking") SparqlService trackerService) {
        long jobInstanceId = this.random.nextLong();
        DatasetListenerTrack listener = new DatasetListenerTrack(trackerService);
        List<DatasetListenerTrack> listeners = Collections.singletonList(listener);
        SparqlServiceFactory result = ssf;
        return result;
    }

    @Bean
    @Autowired
    public Supplier<HttpClient> httpClientSupplier(@Qualifier(value="logging") SparqlService sparqlService) {
        SinkModelWriter sink = new SinkModelWriter(sparqlService);
        HttpInterceptorRdfLogging logger = new HttpInterceptorRdfLogging((Sink)sink);
        PoolingClientConnectionManager connManager = new PoolingClientConnectionManager();
        connManager.setMaxTotal(100);
        connManager.setDefaultMaxPerRoute(100);
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)connManager);
        httpClient.addRequestInterceptor((HttpRequestInterceptor)logger);
        httpClient.addResponseInterceptor((HttpResponseInterceptor)logger);
        HttpOp.setDefaultHttpClient((HttpClient)httpClient);
        HttpOp.setUseDefaultClientWithAuthentication((boolean)true);
        Supplier result = Suppliers.ofInstance((Object)httpClient);
        return result;
    }
}

