/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.config;

import java.util.Date;
import java.util.List;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.core.repository.support.SimpleJobRepository;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.util.Assert;

public class SimpleJobRepositoryFix
extends SimpleJobRepository {
    private JobInstanceDao jobInstanceDao;
    private JobExecutionDao jobExecutionDao;
    private ExecutionContextDao ecDao;

    public SimpleJobRepositoryFix(JobInstanceDao jobInstanceDao, JobExecutionDao jobExecutionDao, StepExecutionDao stepExecutionDao, ExecutionContextDao ecDao) {
        super(jobInstanceDao, jobExecutionDao, stepExecutionDao, ecDao);
        this.jobInstanceDao = jobInstanceDao;
        this.jobExecutionDao = jobExecutionDao;
        this.ecDao = ecDao;
    }

    public JobExecution createJobExecution(String jobName, JobParameters jobParameters) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        Assert.notNull((Object)jobName, (String)"Job name must not be null.");
        Assert.notNull((Object)jobParameters, (String)"JobParameters must not be null.");
        JobInstance jobInstance = this.jobInstanceDao.getJobInstance(jobName, jobParameters);
        ExecutionContext executionContext = null;
        if (jobInstance != null) {
            List executions = this.jobExecutionDao.findJobExecutions(jobInstance);
            for (JobExecution execution : executions) {
                if (execution.isRunning()) {
                    throw new JobExecutionAlreadyRunningException("A job execution for this job is already running: " + jobInstance);
                }
                BatchStatus status = execution.getStatus();
                if (execution.getJobParameters().getParameters().size() <= 0 || status != BatchStatus.COMPLETED && status != BatchStatus.ABANDONED) continue;
                throw new JobInstanceAlreadyCompleteException("A job instance already exists and is complete for parameters=" + jobParameters + ".  If you want to run this job again, change the parameters.");
            }
            JobExecution lastJobExecution = this.jobExecutionDao.getLastJobExecution(jobInstance);
            if (lastJobExecution != null) {
                executionContext = this.ecDao.getExecutionContext(lastJobExecution);
            }
        } else {
            jobInstance = this.jobInstanceDao.createJobInstance(jobName, jobParameters);
        }
        if (executionContext == null) {
            executionContext = new ExecutionContext();
        }
        JobExecution jobExecution = new JobExecution(jobInstance, jobParameters, null);
        jobExecution.setExecutionContext(executionContext);
        jobExecution.setLastUpdated(new Date(System.currentTimeMillis()));
        this.jobExecutionDao.saveJobExecution(jobExecution);
        this.ecDao.saveExecutionContext(jobExecution);
        return jobExecution;
    }
}

