/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.json.rewriters;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.gson.utils.JsonVisitorRewrite;
import org.aksw.spring.json.ContextProcessorJsonUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.support.GenericBeanDefinition;

public class JsonVisitorRewriteBeanDefinition
extends JsonVisitorRewrite {
    protected String subDocKey = "properties";
    protected Predicate<String> isTransferNeeded;

    public static Set<String> getBeanPropertyNames(Class<?> clazz) {
        HashSet<String> result = new HashSet<String>();
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(GenericBeanDefinition.class);
        for (PropertyDescriptor pd : beanWrapper.getPropertyDescriptors()) {
            result.add(pd.getName());
        }
        return result;
    }

    public JsonVisitorRewriteBeanDefinition() {
        Set<String> propertyNames = JsonVisitorRewriteBeanDefinition.getBeanPropertyNames(GenericBeanDefinition.class);
        propertyNames.addAll(ContextProcessorJsonUtils.specialAttributes);
        propertyNames.remove("source");
        this.isTransferNeeded = Predicates.not((Predicate)Predicates.in(propertyNames));
    }

    public JsonElement visit(JsonObject json) {
        JsonObject result;
        if (json.has("beanClassName") && !json.has(this.subDocKey)) {
            result = new JsonObject();
            JsonObject tmp = new JsonObject();
            for (Map.Entry entry : json.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement val = (JsonElement)entry.getValue();
                boolean move = this.isTransferNeeded.apply((Object)key);
                if (move) {
                    tmp.add(key, val);
                    continue;
                }
                result.add(key, val);
            }
            result.add(this.subDocKey, (JsonElement)tmp);
        } else {
            result = json;
        }
        return result;
    }
}

