/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.json.rewriters;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import org.aksw.gson.utils.JsonVisitorRewrite;
import org.aksw.spring.json.ContextProcessorJsonUtils;
import org.apache.commons.lang.StringUtils;

public class JsonVisitorRewriteBeans
extends JsonVisitorRewrite {
    protected Gson gson;

    public JsonVisitorRewriteBeans() {
        this(new Gson());
    }

    public JsonVisitorRewriteBeans(Gson gson) {
        this.gson = gson;
    }

    public static JsonElement expandJava(Gson gson, JsonElement json) {
        JsonElement result = json.isJsonNull() ? json : JsonVisitorRewriteBeans.expandObjectJava(gson, json);
        return result;
    }

    public static JsonObject expandObjectJava(Gson gson, JsonElement json) {
        JsonObject result;
        if (json.isJsonObject()) {
            result = json.getAsJsonObject();
        } else if (json.isJsonArray()) {
            result = JsonVisitorRewriteBeans.expandJavaArray(gson, json.getAsJsonArray());
        } else if (json.isJsonPrimitive()) {
            result = JsonVisitorRewriteBeans.expandJavaPrimitive(gson, json.getAsJsonPrimitive());
        } else {
            throw new RuntimeException("Should not happen");
        }
        return result;
    }

    public static JsonObject expandJavaArray(Gson gson, JsonArray json) {
        JsonObject result = new JsonObject();
        result.addProperty("type", "org.springframework.beans.factory.support.ManagedList");
        result.add("ctor", (JsonElement)json);
        return result;
    }

    public static JsonObject expandJavaPrimitive(Gson gson, JsonPrimitive json) {
        Object val = gson.fromJson((JsonElement)json, Object.class);
        Class<?> clazz = val.getClass();
        JsonArray ctorArgs = new JsonArray();
        ctorArgs.add((JsonElement)json);
        JsonObject result = new JsonObject();
        result.addProperty("type", clazz.getName());
        result.add("ctor", (JsonElement)ctorArgs);
        return result;
    }

    public static JsonElement processValue(Gson gson, JsonElement json, String qualifier) {
        JsonElement result;
        if (!(StringUtils.isEmpty((String)qualifier) || json.isJsonObject() && json.getAsJsonObject().has("qualifier"))) {
            JsonElement tmp = JsonVisitorRewriteBeans.expandJava(gson, json);
            if (tmp.isJsonObject()) {
                JsonObject o = tmp.getAsJsonObject();
                o.addProperty("qualifier", qualifier);
            }
            result = tmp;
        } else {
            result = json;
        }
        return result;
    }

    public JsonElement visit(JsonObject json) {
        JsonObject tmp = new JsonObject();
        boolean isChange = false;
        for (Map.Entry entry : json.entrySet()) {
            String key = (String)entry.getKey();
            Map.Entry keyAndQualifier = ContextProcessorJsonUtils.splitByQualifier((String)key);
            String qualifier = (String)keyAndQualifier.getValue();
            JsonElement value = (JsonElement)entry.getValue();
            JsonElement newValue = JsonVisitorRewriteBeans.processValue(this.gson, value, qualifier);
            isChange = isChange || !value.equals(newValue);
            tmp.add(key, newValue);
        }
        JsonObject result = isChange ? tmp : json;
        return result;
    }
}

