/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.processor;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.SetUtils;
import org.aksw.commons.collections.diff.Diff;
import org.aksw.commons.util.Pair;
import org.aksw.jena_sparql_api.modifier.Modifier;
import org.aksw.jena_sparql_api.utils.DatasetGraphUtils;
import org.aksw.jena_sparql_api.utils.SetDatasetGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.springframework.batch.item.ItemProcessor;

public class ItemProcessorModifierDatasetGraphDiff
implements ItemProcessor<Map.Entry<? extends Node, ? extends DatasetGraph>, Map.Entry<Node, Diff<DatasetGraph>>> {
    private Modifier<? super DatasetGraph> modifier;

    public ItemProcessorModifierDatasetGraphDiff(Modifier<? super DatasetGraph> modifier) {
        this.modifier = modifier;
    }

    public static Diff<DatasetGraph> computeDiff(DatasetGraph base, Modifier<? super DatasetGraph> modifier) {
        DatasetGraph clone = DatasetGraphUtils.clone((DatasetGraph)base);
        modifier.apply((DatasetGraph)clone);
        SetDatasetGraph baseQuads = SetDatasetGraph.wrap((DatasetGraph)base);
        SetDatasetGraph cloneQuads = SetDatasetGraph.wrap((DatasetGraph)clone);
        Diff tmp = ItemProcessorModifierDatasetGraphDiff.createDiff(cloneQuads, baseQuads);
        Diff result = DatasetGraphUtils.wrapDiffDatasetGraph(tmp);
        return result;
    }

    public Map.Entry<Node, Diff<DatasetGraph>> process(Map.Entry<? extends Node, ? extends DatasetGraph> item) {
        Node node = item.getKey();
        DatasetGraph base = item.getValue();
        Diff<DatasetGraph> diff = ItemProcessorModifierDatasetGraphDiff.computeDiff(base, this.modifier);
        Pair result = Pair.create((Object)node, diff);
        return result;
    }

    public static <T> Diff<Set<T>> createDiff(Collection<T> after, Collection<T> before) {
        Set x = SetUtils.asSet(after);
        Set y = SetUtils.asSet(before);
        HashSet added = new HashSet(Sets.difference((Set)x, (Set)y));
        HashSet removed = new HashSet(Sets.difference((Set)y, (Set)x));
        Diff result = Diff.create(added, removed);
        return result;
    }
}

