/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.reader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aksw.jena_sparql_api.batch.BindingMapper;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.pagination.core.PagingQuery;
import org.aksw.jena_sparql_api.pagination.extra.PaginationQueryIterator;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.engine.binding.Binding;
import org.springframework.batch.item.data.AbstractPaginatedDataItemReader;

public class ItemReaderSparqlPaging<T>
extends AbstractPaginatedDataItemReader<T> {
    private QueryExecutionFactory qef;
    private BindingMapper<T> bindingMapper;
    private volatile Query query = null;
    private volatile Iterator<Query> itQuery = null;

    public ItemReaderSparqlPaging() {
        this.setName(((Object)((Object)this)).getClass().getName());
    }

    public void setSparqlService(QueryExecutionFactory qef) {
        this.qef = qef;
    }

    public QueryExecutionFactory getQueryExecutionFactory() {
        return this.qef;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public String getQueryString() {
        return "" + this.query;
    }

    public void setBindingMapper(BindingMapper<T> bindingMapper) {
        this.bindingMapper = bindingMapper;
    }

    public BindingMapper<?> getBindingMapper() {
        return this.bindingMapper;
    }

    protected Iterator<T> doPageRead() {
        PagingQuery pagingQuery = new PagingQuery(Integer.valueOf(this.pageSize), this.query);
        PaginationQueryIterator itQuery = pagingQuery.createQueryIterator(Long.valueOf(this.page * this.pageSize), null);
        Query query = (Query)itQuery.next();
        if (query == null) {
            List tmp = Collections.emptyList();
            return tmp.iterator();
        }
        QueryExecution qe = this.qef.createQueryExecution(query);
        ResultSet rs = qe.execSelect();
        ArrayList<T> items = new ArrayList<T>();
        long rowId = 0L;
        while (rs.hasNext()) {
            Binding binding = rs.nextBinding();
            T item = this.bindingMapper.map(binding, ++rowId);
            items.add(item);
        }
        return items.iterator();
    }
}

