/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.step;

import java.util.HashMap;
import java.util.Map;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.utils.QueryExecutionUtils;
import org.apache.jena.query.Query;
import org.springframework.batch.core.partition.support.Partitioner;
import org.springframework.batch.item.ExecutionContext;

public class PartitionerSparqlSlice
implements Partitioner {
    protected QueryExecutionFactory qef;
    protected Query query;
    protected Long pageSize;

    public PartitionerSparqlSlice() {
    }

    public PartitionerSparqlSlice(QueryExecutionFactory qef, Query query) {
        this.qef = qef;
        this.query = query;
    }

    public QueryExecutionFactory getSource() {
        return this.qef;
    }

    public void setSource(QueryExecutionFactory qef) {
        this.qef = qef;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Long pageSize) {
        this.pageSize = pageSize;
    }

    public Map<String, ExecutionContext> partition(int requestedGridSize) {
        long min = 0L;
        long max = QueryExecutionUtils.countQuery((Query)this.query, (QueryExecutionFactory)this.qef);
        long gridSize = this.pageSize == null ? (long)requestedGridSize : Math.min((long)requestedGridSize, (max + this.pageSize - 1L) / this.pageSize);
        long targetSize = (max - min) / gridSize + 1L;
        long number = 0L;
        long start = min;
        long end = start + targetSize - 1L;
        HashMap<String, ExecutionContext> result = new HashMap<String, ExecutionContext>();
        while (start <= max) {
            ExecutionContext value = new ExecutionContext();
            result.put("partition" + number, value);
            if (end >= max) {
                end = max;
            }
            value.putLong("minValue", start);
            value.putLong("maxValue", end);
            start += targetSize;
            end += targetSize;
            ++number;
        }
        return result;
    }
}

