/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.tasklet;

import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.utils.QueryExecutionUtils;
import org.apache.jena.query.Query;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class TaskletSparqlCountData
extends StepExecutionListenerSupport
implements Tasklet,
InitializingBean {
    protected Query query;
    protected QueryExecutionFactory qef;
    protected String key;

    public TaskletSparqlCountData(Query query, QueryExecutionFactory qef, String key) {
        this.query = query;
        this.qef = qef;
        this.key = key;
    }

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        long count = QueryExecutionUtils.countQuery((Query)this.query, (QueryExecutionFactory)this.qef);
        String k = this.key != null ? this.key : chunkContext.getStepContext().getStepName() + ".count";
        chunkContext.getStepContext().getStepExecution().getJobExecution().getExecutionContext().put(k, (Object)count);
        return RepeatStatus.FINISHED;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.query);
        Assert.notNull((Object)this.qef);
    }
}

