/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.trash;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterators;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.aksw.jena_sparql_api.batch.step.F_QuadToBinding;
import org.aksw.jena_sparql_api.batch.step.F_TripleToQuad;
import org.aksw.jena_sparql_api.core.QueryExecutionAdapter;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;

public class QueryExecutionResourceCore
extends QueryExecutionAdapter {
    private String fileNameOrUrl;
    private TypedInputStream tis;

    public QueryExecutionResourceCore(String fileNameOrUrl) {
        this.fileNameOrUrl = fileNameOrUrl;
    }

    public ResultSet execSelect() {
        if (this.tis != null) {
            throw new RuntimeException("Query execution already running");
        }
        this.tis = RDFDataMgr.open((String)this.fileNameOrUrl);
        Lang lang = RDFDataMgr.determineLang((String)this.fileNameOrUrl, null, null);
        String base = this.tis.getBaseURI();
        Iterator itTriple = RDFDataMgr.createIteratorTriples((InputStream)this.tis, (Lang)lang, (String)base);
        Function fn = Functions.compose((Function)F_QuadToBinding.fn, (Function)F_TripleToQuad.fn);
        Iterator itBinding = Iterators.transform((Iterator)itTriple, (Function)fn);
        QueryIterPlainWrapper queryIter = new QueryIterPlainWrapper(itBinding);
        List<String> varNames = Arrays.asList("g", "s", "p", "o");
        ResultSet rs = ResultSetFactory.create((QueryIterator)queryIter, varNames);
        return rs;
    }

    public void abort() {
        this.close();
    }

    public void close() {
        this.tis.close();
    }
}

