/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.writer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aksw.commons.collections.diff.Diff;
import org.aksw.jena_sparql_api.core.UpdateExecutionFactory;
import org.aksw.jena_sparql_api.core.utils.UpdateDiffUtils;
import org.aksw.jena_sparql_api.core.utils.UpdateExecutionUtils;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ItemWriterSparqlDiff
implements ItemWriter<Map.Entry<? extends Node, ? extends Diff<? extends DatasetGraph>>>,
InitializingBean {
    private UpdateExecutionFactory uef;

    public ItemWriterSparqlDiff(UpdateExecutionFactory uef) {
        this.uef = uef;
    }

    public UpdateExecutionFactory getUpdateExecutionFactory() {
        return this.uef;
    }

    public void setUpdateExecutionFactory(UpdateExecutionFactory uef) {
        this.uef = uef;
    }

    public void write(List<? extends Map.Entry<? extends Node, ? extends Diff<? extends DatasetGraph>>> items) throws Exception {
        block3: {
            ArrayList diffs = Lists.newArrayList();
            for (Map.Entry<? extends Node, ? extends Diff<? extends DatasetGraph>> entry : items) {
                Diff<? extends DatasetGraph> diff = entry.getValue();
                diffs.add(diff);
            }
            Diff diff = UpdateDiffUtils.combineDatasetGraph((Iterable)diffs);
            try {
                UpdateExecutionUtils.executeUpdateDatasetGraph((UpdateExecutionFactory)this.uef, (Diff)diff);
            }
            catch (Exception exception) {
                if (!(exception instanceof HttpException)) break block3;
                HttpException x = (HttpException)exception;
                String response = x.getResponse();
                throw new RuntimeException(response, exception);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.uef);
    }
}

