/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.convert;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import org.aksw.jena_sparql_api.convert.VocabWriter;
import org.aksw.jena_sparql_api.geo.vocab.GEO;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.XSD;

public class VocabWriterWgs84
implements VocabWriter<Geometry> {
    protected boolean ignoreInvalidGeometry = false;
    protected String datatypeUri = XSD.xstring.getURI();

    @Override
    public void write(Model model, Resource base, Geometry value) {
        if (value instanceof Point) {
            Point point = (Point)value;
            double x = point.getX();
            double y = point.getY();
            Literal xlong = model.createTypedLiteral((Object)x, this.datatypeUri);
            Literal lat = model.createTypedLiteral((Object)y, this.datatypeUri);
            model.add(base, GEO.xlong, (RDFNode)xlong);
            model.add(base, GEO.lat, (RDFNode)lat);
        } else if (!this.ignoreInvalidGeometry) {
            throw new RuntimeException("A point geometry was expected, got " + value);
        }
    }
}

