/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.hop;

import com.google.common.base.Functions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.concepts.Relation;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.utils.ServiceUtils;
import org.aksw.jena_sparql_api.hop.Hop;
import org.aksw.jena_sparql_api.hop.HopQuery;
import org.aksw.jena_sparql_api.hop.HopRelation;
import org.aksw.jena_sparql_api.lookup.CountInfo;
import org.aksw.jena_sparql_api.lookup.ListService;
import org.aksw.jena_sparql_api.lookup.ListServiceUtils;
import org.aksw.jena_sparql_api.lookup.LookupService;
import org.aksw.jena_sparql_api.lookup.LookupServiceListService;
import org.aksw.jena_sparql_api.lookup.LookupServicePartition;
import org.aksw.jena_sparql_api.lookup.LookupServiceUtils;
import org.aksw.jena_sparql_api.mapper.MappedQuery;
import org.aksw.jena_sparql_api.utils.DatasetGraphUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;

public class ListServiceHop
implements ListService<Concept, Node, DatasetGraph> {
    protected QueryExecutionFactory defaultQef;
    protected Hop root;
    public static int chunkSize = 30;

    public ListServiceHop(QueryExecutionFactory defaultQef, Hop root) {
        this.defaultQef = defaultQef;
        this.root = root;
    }

    public Map<Node, DatasetGraph> fetchData(Concept concept, Long limit, Long offset) {
        List sourceNodes = ServiceUtils.fetchList((QueryExecutionFactory)this.defaultQef, (Concept)concept, (Long)limit, (Long)offset);
        HashMap<Node, DatasetGraph> result = new HashMap<Node, DatasetGraph>();
        ListServiceHop.execRec(this.root, sourceNodes, result, this.defaultQef, null);
        return result;
    }

    public CountInfo fetchCount(Concept concept, Long itemLimit, Long rowLimit) {
        CountInfo result = ServiceUtils.fetchCountConcept((QueryExecutionFactory)this.defaultQef, (Concept)concept, (Long)itemLimit, (Long)rowLimit);
        return result;
    }

    public static void execQueriesHop(QueryExecutionFactory qef, Collection<Node> nodes, Collection<MappedQuery<DatasetGraph>> mappedQueries, Map<Node, DatasetGraph> result) {
        for (MappedQuery<DatasetGraph> mappedQuery : mappedQueries) {
            ListService listService = ListServiceUtils.createListServiceMappedQuery((QueryExecutionFactory)qef, mappedQuery, (boolean)true);
            LookupServiceListService lookupService = LookupServiceListService.create((ListService)listService);
            lookupService = LookupServicePartition.create((LookupService)lookupService, (int)chunkSize);
            Map nodeToGraph = (Map)lookupService.apply(nodes);
            DatasetGraphUtils.mergeInPlace(result, (Map)nodeToGraph);
        }
    }

    public static void processHopQuery(HopQuery hopQuery, Collection<Node> sourceNodes, Map<Node, DatasetGraph> result, QueryExecutionFactory defaultQef, Multimap<Node, Node> back) {
        HashMap<Node, DatasetGraph> map;
        QueryExecutionFactory qef = hopQuery.getQef();
        qef = qef == null ? defaultQef : qef;
        MappedQuery<DatasetGraph> mappedQuery = hopQuery.getMappedQuery();
        LookupService ls = LookupServiceUtils.createLookupService((QueryExecutionFactory)qef, mappedQuery);
        ls = LookupServicePartition.create((LookupService)ls, (int)chunkSize);
        HashMap<Node, DatasetGraph> tmpMap = (HashMap<Node, DatasetGraph>)ls.apply(sourceNodes);
        if (back != null) {
            map = new HashMap<Node, DatasetGraph>();
            for (Map.Entry entry : tmpMap.entrySet()) {
                Node tmpNode = (Node)entry.getKey();
                DatasetGraph datasetGraph = (DatasetGraph)entry.getValue();
                Collection keys = back.get((Object)tmpNode);
                for (Node key : keys) {
                    map.put(key, datasetGraph);
                }
            }
        } else {
            map = tmpMap;
        }
        DatasetGraphUtils.mergeInPlace(result, map);
    }

    public static void processHopQueries(List<HopQuery> hopQueries, Collection<Node> sourceNodes, Map<Node, DatasetGraph> result, QueryExecutionFactory defaultQef, Multimap<Node, Node> back) {
        for (HopQuery hopQuery : hopQueries) {
            ListServiceHop.processHopQuery(hopQuery, sourceNodes, result, defaultQef, back);
        }
    }

    public static <T, C extends Iterable<T>> Iterable<T> flatMap(Map<T, C> map) {
        FluentIterable result = FluentIterable.from(map.values()).transformAndConcat(Functions.identity());
        return result;
    }

    public static void processHopRelations(List<HopRelation> hopRelations, Collection<Node> sourceNodes, Map<Node, DatasetGraph> result, QueryExecutionFactory defaultQef, Multimap<Node, Node> back) {
        for (HopRelation hopRelation : hopRelations) {
            ListServiceHop.processHopRelation(hopRelation, sourceNodes, result, defaultQef, back);
        }
    }

    public static void processHopRelation(HopRelation hopRelation, Collection<Node> sourceNodes, Map<Node, DatasetGraph> result, QueryExecutionFactory defaultQef, Multimap<Node, Node> back) {
        HashMultimap nextBack;
        QueryExecutionFactory qef = hopRelation.getQef();
        qef = qef == null ? defaultQef : qef;
        Relation relation = hopRelation.getRelation();
        LookupService ls = LookupServiceUtils.createLookupService((QueryExecutionFactory)qef, (Relation)relation);
        ls = LookupServicePartition.create((LookupService)ls, (int)chunkSize);
        Map map = (Map)ls.apply(sourceNodes);
        HashMultimap tmpMm = HashMultimap.create();
        for (Map.Entry entry : map.entrySet()) {
            tmpMm.putAll(entry.getKey(), (Iterable)entry.getValue());
        }
        Multimap tmpBack = Multimaps.invertFrom((Multimap)tmpMm, (Multimap)HashMultimap.create());
        if (back != null) {
            nextBack = HashMultimap.create();
            for (Map.Entry entry : nextBack.entries()) {
                Node src = (Node)entry.getKey();
                Node tmp = (Node)entry.getValue();
                Collection tgts = back.get((Object)tmp);
                for (Node tgt : tgts) {
                    nextBack.put((Object)src, (Object)tgt);
                }
            }
        } else {
            nextBack = tmpBack;
        }
        HashSet relatedNodes = Sets.newHashSet(ListServiceHop.flatMap(map));
        for (Hop hop : hopRelation.getHops()) {
            ListServiceHop.execRec(hop, relatedNodes, result, qef, (Multimap<Node, Node>)nextBack);
        }
    }

    public static void execRec(Hop hop, Collection<Node> sourceNodes, Map<Node, DatasetGraph> result, QueryExecutionFactory defaultQef, Multimap<Node, Node> back) {
        List<HopQuery> hopQueries = hop.getHopQueries();
        List<HopRelation> hopRelations = hop.getHopRelations();
        ListServiceHop.processHopQueries(hopQueries, sourceNodes, result, defaultQef, back);
        ListServiceHop.processHopRelations(hopRelations, sourceNodes, result, defaultQef, back);
    }
}

