/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.modifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aksw.jena_sparql_api.modifier.Modifier;

public class ModifierList<T>
implements Modifier<T> {
    private List<Modifier<? super T>> modifiers;

    @SafeVarargs
    public ModifierList(Modifier<? super T> ... modifiers) {
        this.modifiers = Arrays.asList(modifiers);
    }

    public ModifierList(List<Modifier<? super T>> modifiers) {
        this.modifiers = modifiers;
    }

    @Override
    public void apply(T item) {
        for (Modifier<T> modifier : this.modifiers) {
            modifier.apply(item);
        }
    }

    @SafeVarargs
    public static <T> ModifierList<T> create(Modifier<T> ... modifiers) {
        ModifierList<T> result = ModifierList.create(Arrays.asList(modifiers));
        return result;
    }

    public static <T> ModifierList<T> create(List<? extends Modifier<? super T>> modifiers) {
        ArrayList<Modifier<T>> tmps = new ArrayList<Modifier<T>>(modifiers.size());
        for (Modifier<T> modifier : modifiers) {
            tmps.add(modifier);
        }
        ModifierList<? super T> result = new ModifierList<T>(tmps);
        return result;
    }
}

