/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.spring.conversion;

import java.util.Collection;
import java.util.Map;
import org.aksw.jena_sparql_api.spring.conversion.AutoRegistered;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.support.ConversionServiceFactoryBean;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.ConfigurableConversionService;

public class ConverterRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ConverterRegistryPostProcessor.class);

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(ConversionServiceFactoryBean.class).getBeanDefinition();
        registry.registerBeanDefinition("conversionService", (BeanDefinition)beanDefinition);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Map beansWithAnnotation = beanFactory.getBeansWithAnnotation(AutoRegistered.class);
        Collection converters = beansWithAnnotation.values();
        ConfigurableConversionService conversionService = (ConfigurableConversionService)beanFactory.getBean("conversionService");
        for (Object converter : converters) {
            logger.debug("AutoRegistered converter: " + converter.getClass() + " - " + converter);
            conversionService.addConverter((Converter)converter);
        }
        logger.debug("AutoRegistered " + converters.size() + " converters");
    }
}

