/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.Map;
import org.aksw.jena_sparql_api.batch.config.ConfigBatchJobDynamic;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.configuration.annotation.AbstractBatchConfiguration;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabase;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseBuilder;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.jdbc.datasource.init.ScriptException;

public class BatchWorkflowManager {
    private AbstractBatchConfiguration config;

    public void processWorkflow(String workflow) {
        Gson gson = new Gson();
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        gson.fromJson(workflow, type);
    }

    public BatchWorkflowManager(AbstractBatchConfiguration config) {
        this.config = config;
    }

    public JobExecution launch(Job job, JobParameters jobParameters) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JobParametersInvalidException, Exception {
        BatchStatus status;
        JobExecution result = this.config.jobRepository().getLastJobExecution(job.getName(), jobParameters);
        BatchStatus batchStatus = status = result == null ? null : result.getStatus();
        if (status == null || !status.isRunning() && !status.equals((Object)BatchStatus.COMPLETED)) {
            result = this.config.jobLauncher().run(job, jobParameters);
        }
        return result;
    }

    public static BatchWorkflowManager createTestInstance() throws ScriptException, SQLException {
        AnnotationConfigApplicationContext context;
        EmbeddedDatabaseBuilder edb = new EmbeddedDatabaseBuilder();
        EmbeddedDatabase ed = edb.setType(EmbeddedDatabaseType.H2).addScript("classpath:org/springframework/batch/core/schema-drop-h2.sql").addScript("classpath:org/springframework/batch/core/schema-h2.sql").build();
        AnnotationConfigApplicationContext cac = context = new AnnotationConfigApplicationContext();
        ConfigurableListableBeanFactory beanFactory = cac.getBeanFactory();
        beanFactory.registerSingleton(ed.getClass().getCanonicalName(), (Object)ed);
        context.register(new Class[]{ConfigBatchJobDynamic.class});
        context.refresh();
        AbstractBatchConfiguration batchConfig = (AbstractBatchConfiguration)context.getBean(AbstractBatchConfiguration.class);
        BatchWorkflowManager result = new BatchWorkflowManager(batchConfig);
        return result;
    }
}

