/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import org.aksw.jena_sparql_api.batch.FunctionCache;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionBase;
import org.apache.jena.sparql.function.FunctionFactory;

public class FunctionFactoryCache
implements FunctionFactory {
    private FunctionFactory delegate;
    private Cache<List<NodeValue>, NodeValue> cache;

    public FunctionFactoryCache(FunctionFactory delegate, Cache<List<NodeValue>, NodeValue> cache) {
        this.delegate = delegate;
        this.cache = cache;
    }

    public Function create(String name) {
        Function tmp = this.delegate.create(name);
        FunctionBase x = (FunctionBase)tmp;
        FunctionCache result = new FunctionCache(x, this.cache);
        return result;
    }

    public static FunctionFactoryCache create(FunctionFactory delegate) {
        Cache cache = CacheBuilder.newBuilder().maximumSize(1000L).build();
        FunctionFactoryCache result = FunctionFactoryCache.create(delegate, (Cache<List<NodeValue>, NodeValue>)cache);
        return result;
    }

    public static FunctionFactoryCache create(FunctionFactory delegate, Cache<List<NodeValue>, NodeValue> cache) {
        FunctionFactoryCache result = new FunctionFactoryCache(delegate, cache);
        return result;
    }
}

