/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch;

import com.google.gson.Gson;
import java.util.Map;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.configuration.annotation.AbstractBatchConfiguration;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobRepository;

public class JobLauncherWorkflow {
    public static final String JOB_CONTEXT = "context";
    private AbstractBatchConfiguration config;
    private Gson gson;

    public JobLauncherWorkflow(AbstractBatchConfiguration config, Gson gson) {
        this.config = config;
        this.gson = gson;
    }

    public JobExecution launchJob(String workflow) throws Exception {
        BatchStatus status;
        Map data = (Map)this.gson.fromJson(workflow, Map.class);
        JobRepository jobRepository = this.config.jobRepository();
        JobLauncher jobLauncher = this.config.jobLauncher();
        Job job = null;
        JobParameters jobParameters = new JobParametersBuilder().addString(JOB_CONTEXT, workflow, true).toJobParameters();
        JobExecution result = jobRepository.getLastJobExecution(job.getName(), jobParameters);
        BatchStatus batchStatus = status = result == null ? null : result.getStatus();
        if (status != null && (status.isRunning() || status.equals((Object)BatchStatus.COMPLETED))) {
            return result;
        }
        result = jobLauncher.run(job, jobParameters);
        return result;
    }
}

