/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.mapper.Agg;
import org.aksw.jena_sparql_api.mapper.AggDatasetGraph;
import org.aksw.jena_sparql_api.mapper.AggGraph;
import org.aksw.jena_sparql_api.mapper.MappedConcept;
import org.aksw.jena_sparql_api.utils.NodeTransformRenameMap;
import org.aksw.jena_sparql_api.utils.NodeUtils;
import org.aksw.jena_sparql_api.utils.VarGeneratorBlacklist;
import org.aksw.jena_sparql_api.utils.transform.NodeTransformCollectNodes;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.Template;
import org.springframework.util.Assert;

public class QueryTransformConstructGroupedGraph {
    public static MappedConcept<DatasetGraph> query2(Query query, Var partitionVar) {
        Assert.isTrue((boolean)query.isConstructType());
        Template template = query.getConstructTemplate();
        BasicPattern bgp = template.getBGP();
        BasicPattern newBgp = QueryTransformConstructGroupedGraph.allocVarsForBlankNodes(bgp);
        Var g = Var.alloc((String)"_g_");
        ElementTriplesBlock tmp = new ElementTriplesBlock(newBgp);
        ElementNamedGraph newElement = new ElementNamedGraph((Node)g, (Element)tmp);
        OpQuadPattern tmpOp = new OpQuadPattern((Node)g, newBgp);
        QuadPattern quadPattern = tmpOp.getPattern();
        Concept concept = new Concept((Element)newElement, partitionVar);
        AggDatasetGraph agg = AggDatasetGraph.create((QuadPattern)quadPattern);
        MappedConcept result = MappedConcept.create((Concept)concept, (Agg)agg);
        return result;
    }

    public static BasicPattern allocVarsForBlankNodes(BasicPattern bgp) {
        NodeTransformCollectNodes collector = new NodeTransformCollectNodes();
        NodeTransformLib.transform((NodeTransform)collector, (BasicPattern)bgp);
        Set nodes = collector.getNodes();
        Set vars = NodeUtils.getVarsMentioned((Iterable)nodes);
        Set bnodes = NodeUtils.getBnodesMentioned((Iterable)nodes);
        VarGeneratorBlacklist gen = VarGeneratorBlacklist.create((String)"v", (Collection)vars);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Node node : bnodes) {
            map.put(node, gen.next());
        }
        for (Var var : vars) {
            if (!var.getName().startsWith("?")) continue;
            map.put(var, gen.next());
        }
        NodeTransformRenameMap nodeTransform = new NodeTransformRenameMap(map);
        BasicPattern result = NodeTransformLib.transform((NodeTransform)nodeTransform, (BasicPattern)bgp);
        return result;
    }

    public static MappedConcept<Graph> query(Query query, Var partitionVar) {
        Assert.isTrue((boolean)query.isConstructType());
        Template template = query.getConstructTemplate();
        BasicPattern bgp = template.getBGP();
        BasicPattern newBgp = QueryTransformConstructGroupedGraph.allocVarsForBlankNodes(bgp);
        ElementTriplesBlock newElement = new ElementTriplesBlock(newBgp);
        Template newTemplate = new Template(newBgp);
        Concept concept = new Concept((Element)newElement, partitionVar);
        AggGraph agg = AggGraph.create((Template)newTemplate);
        MappedConcept result = MappedConcept.create((Concept)concept, (Agg)agg);
        return result;
    }
}

