/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.backend.sparql;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class FunctionMemoize<I, O>
implements Function<I, O> {
    protected Map<I, O> cache = new HashMap<I, O>();
    protected Function<I, O> delegate;

    public FunctionMemoize(Function<I, O> delegate) {
        this(delegate, new HashMap());
    }

    public FunctionMemoize(Function<I, O> delegate, Map<I, O> cache) {
        this.delegate = delegate;
    }

    public Map<I, O> getCache() {
        return this.cache;
    }

    public void setCache(Map<I, O> cache) {
        this.cache = cache;
    }

    public Function<I, O> getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Function<I, O> delegate) {
        this.delegate = delegate;
    }

    @Override
    public O apply(I t) {
        O result = this.cache.computeIfAbsent(t, this.delegate);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cache == null ? 0 : this.cache.hashCode());
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionMemoize other = (FunctionMemoize)obj;
        if (this.cache == null ? other.cache != null : !this.cache.equals(other.cache)) {
            return false;
        }
        return !(this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate));
    }

    public String toString() {
        return "FunctionMemoize [cache=" + this.cache + ", delegate=" + this.delegate + "]";
    }
}

