/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.backend.sparql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.aksw.jena_sparql_api.geo.vocab.BATCH;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.DCTerms;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.repository.dao.AbstractJdbcBatchMetadataDao;
import org.springframework.batch.core.repository.dao.JdbcJobExecutionDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.NoSuchObjectException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.util.Assert;

public class JobExecutionDaoSparql
extends AbstractJdbcBatchMetadataDao
implements JobExecutionDao,
InitializingBean {
    private static final Log logger = LogFactory.getLog(JdbcJobExecutionDao.class);
    protected EntityManager em;
    public static List<Property> properties = Arrays.asList(BATCH.jobExecutionId, BATCH.startTime, BATCH.endTime, BATCH.status, BATCH.exitCode, BATCH.exitMessage, DCTerms.created, DCTerms.modified, BATCH.version, BATCH.jobConfigurationLocation);
    private static final String UPDATE_JOB_EXECUTION = "MODIFY ...";
    private static final String SAVE_JOB_EXECUTION = "INSERT into %PREFIX%JOB_EXECUTION(JOB_EXECUTION_ID, JOB_INSTANCE_ID, START_TIME, END_TIME, STATUS, EXIT_CODE, EXIT_MESSAGE, VERSION, CREATE_TIME, LAST_UPDATED, JOB_CONFIGURATION_LOCATION) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String CHECK_JOB_EXECUTION_EXISTS = "SELECT COUNT(*) FROM %PREFIX%JOB_EXECUTION WHERE JOB_EXECUTION_ID = ?";
    private static final String GET_STATUS = "SELECT STATUS from %PREFIX%JOB_EXECUTION where JOB_EXECUTION_ID = ?";
    private static final String FIND_JOB_EXECUTIONS = "SELECT JOB_EXECUTION_ID, START_TIME, END_TIME, STATUS, EXIT_CODE, EXIT_MESSAGE, CREATE_TIME, LAST_UPDATED, VERSION, JOB_CONFIGURATION_LOCATION from %PREFIX%JOB_EXECUTION where JOB_INSTANCE_ID = ? order by JOB_EXECUTION_ID desc";
    private static final String GET_LAST_EXECUTION = "SELECT JOB_EXECUTION_ID, START_TIME, END_TIME, STATUS, EXIT_CODE, EXIT_MESSAGE, CREATE_TIME, LAST_UPDATED, VERSION, JOB_CONFIGURATION_LOCATION from %PREFIX%JOB_EXECUTION E where JOB_INSTANCE_ID = ? and JOB_EXECUTION_ID in (SELECT max(JOB_EXECUTION_ID) from %PREFIX%JOB_EXECUTION E2 where E2.JOB_INSTANCE_ID = ?)";
    private static final String GET_EXECUTION_BY_ID = "SELECT JOB_EXECUTION_ID, START_TIME, END_TIME, STATUS, EXIT_CODE, EXIT_MESSAGE, CREATE_TIME, LAST_UPDATED, VERSION, JOB_CONFIGURATION_LOCATION from %PREFIX%JOB_EXECUTION where JOB_EXECUTION_ID = ?";
    private static final String GET_RUNNING_EXECUTIONS = "SELECT E.JOB_EXECUTION_ID, E.START_TIME, E.END_TIME, E.STATUS, E.EXIT_CODE, E.EXIT_MESSAGE, E.CREATE_TIME, E.LAST_UPDATED, E.VERSION, E.JOB_INSTANCE_ID, E.JOB_CONFIGURATION_LOCATION from %PREFIX%JOB_EXECUTION E, %PREFIX%JOB_INSTANCE I where E.JOB_INSTANCE_ID=I.JOB_INSTANCE_ID and I.JOB_NAME=? and E.END_TIME is NULL order by E.JOB_EXECUTION_ID desc";
    private static final String CURRENT_VERSION_JOB_EXECUTION = "SELECT VERSION FROM %PREFIX%JOB_EXECUTION WHERE JOB_EXECUTION_ID=?";
    private static final String FIND_PARAMS_FROM_ID = "SELECT JOB_EXECUTION_ID, KEY_NAME, TYPE_CD, STRING_VAL, DATE_VAL, LONG_VAL, DOUBLE_VAL, IDENTIFYING from %PREFIX%JOB_EXECUTION_PARAMS where JOB_EXECUTION_ID = ?";
    private static final String CREATE_JOB_PARAMETERS = "INSERT into %PREFIX%JOB_EXECUTION_PARAMS(JOB_EXECUTION_ID, KEY_NAME, TYPE_CD, STRING_VAL, DATE_VAL, LONG_VAL, DOUBLE_VAL, IDENTIFYING) values (?, ?, ?, ?, ?, ?, ?, ?)";
    private int exitMessageLength = 2500;
    private DataFieldMaxValueIncrementer jobExecutionIncrementer;

    public JobExecutionDaoSparql(EntityManager em) {
        this.em = em;
    }

    public void createQuerySimpleInsert(List<Property> properties) {
    }

    public void setExitMessageLength(int exitMessageLength) {
        this.exitMessageLength = exitMessageLength;
    }

    public void setJobExecutionIncrementer(DataFieldMaxValueIncrementer jobExecutionIncrementer) {
        this.jobExecutionIncrementer = jobExecutionIncrementer;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.jobExecutionIncrementer, (String)"The jobExecutionIncrementer must not be null.");
    }

    public List<JobExecution> findJobExecutions(JobInstance job) {
        CriteriaQuery cq = this.em.getCriteriaBuilder().createQuery(JobExecution.class);
        TypedQuery tq = this.em.createQuery(cq);
        List result = tq.getResultList();
        return result;
    }

    public void saveJobExecution(JobExecution jobExecution) {
        this.validateJobExecution(jobExecution);
        jobExecution.incrementVersion();
        this.em.persist((Object)jobExecution);
    }

    private void validateJobExecution(JobExecution jobExecution) {
        Assert.notNull((Object)jobExecution);
        Assert.notNull((Object)jobExecution.getJobId(), (String)"JobExecution Job-Id cannot be null.");
        Assert.notNull((Object)jobExecution.getStatus(), (String)"JobExecution status cannot be null.");
        Assert.notNull((Object)jobExecution.getCreateTime(), (String)"JobExecution create time cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJobExecution(JobExecution jobExecution) {
        this.validateJobExecution(jobExecution);
        Assert.notNull((Object)jobExecution.getId(), (String)"JobExecution ID cannot be null. JobExecution must be saved before it can be updated");
        Assert.notNull((Object)jobExecution.getVersion(), (String)"JobExecution version cannot be null. JobExecution must be saved before it can be updated");
        JobExecution jobExecution2 = jobExecution;
        synchronized (jobExecution2) {
            Integer version = jobExecution.getVersion() + 1;
            String exitDescription = jobExecution.getExitStatus().getExitDescription();
            if (exitDescription != null && exitDescription.length() > this.exitMessageLength) {
                exitDescription = exitDescription.substring(0, this.exitMessageLength);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Truncating long message before update of JobExecution: " + jobExecution));
                }
            }
            Object[] parameters = new Object[]{jobExecution.getStartTime(), jobExecution.getEndTime(), jobExecution.getStatus().toString(), jobExecution.getExitStatus().getExitCode(), exitDescription, version, jobExecution.getCreateTime(), jobExecution.getLastUpdated(), jobExecution.getId(), jobExecution.getVersion()};
            if ((Integer)this.getJdbcTemplate().queryForObject(this.getQuery(CHECK_JOB_EXECUTION_EXISTS), Integer.class, new Object[]{jobExecution.getId()}) != 1) {
                throw new NoSuchObjectException("Invalid JobExecution, ID " + jobExecution.getId() + " not found.");
            }
            int count = this.getJdbcTemplate().update(this.getQuery(UPDATE_JOB_EXECUTION), parameters, new int[]{93, 93, 12, 12, 12, 4, 93, 93, -5, 4});
            if (count == 0) {
                int curentVersion = (Integer)this.getJdbcTemplate().queryForObject(this.getQuery(CURRENT_VERSION_JOB_EXECUTION), Integer.class, new Object[]{jobExecution.getId()});
                throw new OptimisticLockingFailureException("Attempt to update job execution id=" + jobExecution.getId() + " with wrong version (" + jobExecution.getVersion() + "), where current version is " + curentVersion);
            }
            jobExecution.incrementVersion();
        }
    }

    public JobExecution getLastJobExecution(JobInstance jobInstance) {
        Long id = jobInstance.getId();
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(JobExecution.class);
        Root c = q.from(JobExecution.class);
        CriteriaQuery x = q.select((Selection)c).where((Expression)cb.gt((Expression)c.get("jobInstance.id"), (Number)id));
        TypedQuery query = this.em.createQuery(x);
        JobExecution result = (JobExecution)query.getSingleResult();
        return result;
    }

    public JobExecution getJobExecution(Long executionId) {
        try {
            CriteriaBuilder cb = this.em.getCriteriaBuilder();
            CriteriaQuery q = cb.createQuery(JobExecution.class);
            Root c = q.from(JobExecution.class);
            CriteriaQuery x = q.select((Selection)c).where((Expression)cb.gt((Expression)c.get("jobInstance.id"), (Number)executionId));
            TypedQuery query = this.em.createQuery(x);
            JobExecution result = (JobExecution)query.getSingleResult();
            return result;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public Set<JobExecution> findRunningJobExecutions(String jobName) {
        HashSet<JobExecution> result = new HashSet<JobExecution>();
        RowCallbackHandler handler = new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
            }
        };
        this.getJdbcTemplate().query(this.getQuery(GET_RUNNING_EXECUTIONS), new Object[]{jobName}, handler);
        return result;
    }

    public void synchronizeStatus(JobExecution jobExecution) {
        int currentVersion = (Integer)this.getJdbcTemplate().queryForObject(this.getQuery(CURRENT_VERSION_JOB_EXECUTION), Integer.class, new Object[]{jobExecution.getId()});
        if (currentVersion != jobExecution.getVersion()) {
            String status = (String)this.getJdbcTemplate().queryForObject(this.getQuery(GET_STATUS), String.class, new Object[]{jobExecution.getId()});
            jobExecution.upgradeStatus(BatchStatus.valueOf((String)status));
            jobExecution.setVersion(Integer.valueOf(currentVersion));
        }
    }

    private void insertJobParameters(Resource jobParamsRes, Long executionId, JobParameters jobParameters) {
        jobParamsRes.addLiteral(BATCH.jobExecutionId, (Object)executionId);
        for (Map.Entry entry : jobParameters.getParameters().entrySet()) {
            Resource jobParamRes = jobParamsRes.getModel().createResource();
            jobParamsRes.addProperty(BATCH.hasParam, (RDFNode)jobParamRes);
            String key = (String)entry.getKey();
            JobParameter jobParameter = (JobParameter)entry.getValue();
            this.insertParameter(jobParamRes, executionId, jobParameter.getType(), (String)entry.getKey(), jobParameter.getValue(), jobParameter.isIdentifying());
        }
    }

    private void insertParameter(Resource jobParamRes, Long executionId, JobParameter.ParameterType type, String key, Object value, boolean identifying) {
        jobParamRes.addLiteral(BATCH.jobExecutionId, (Object)executionId).addLiteral(BATCH.key, (Object)key).addLiteral(BATCH.value, value).addLiteral(BATCH.identifying, identifying);
    }

    protected JobParameters getJobParameters(Long executionId) {
        final HashMap map = new HashMap();
        RowCallbackHandler handler = new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                JobParameter.ParameterType type = JobParameter.ParameterType.valueOf((String)rs.getString(3));
                JobParameter value = null;
                if (type == JobParameter.ParameterType.STRING) {
                    value = new JobParameter(rs.getString(4), rs.getString(8).equalsIgnoreCase("Y"));
                } else if (type == JobParameter.ParameterType.LONG) {
                    value = new JobParameter(Long.valueOf(rs.getLong(6)), rs.getString(8).equalsIgnoreCase("Y"));
                } else if (type == JobParameter.ParameterType.DOUBLE) {
                    value = new JobParameter(Double.valueOf(rs.getDouble(7)), rs.getString(8).equalsIgnoreCase("Y"));
                } else if (type == JobParameter.ParameterType.DATE) {
                    value = new JobParameter((Date)rs.getTimestamp(5), rs.getString(8).equalsIgnoreCase("Y"));
                }
                map.put(rs.getString(2), value);
            }
        };
        this.getJdbcTemplate().query(this.getQuery(FIND_PARAMS_FROM_ID), new Object[]{executionId}, handler);
        return new JobParameters(map);
    }
}

