/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.backend.sparql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.core.DefaultJobKeyGenerator;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobKeyGenerator;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.repository.dao.AbstractJdbcBatchMetadataDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JobInstanceDaoSparql
extends AbstractJdbcBatchMetadataDao
implements JobInstanceDao,
InitializingBean {
    private static final String STAR_WILDCARD = "*";
    private static final String SQL_WILDCARD = "%";
    private static final String CREATE_JOB_INSTANCE = "INSERT into %PREFIX%JOB_INSTANCE(JOB_INSTANCE_ID, JOB_NAME, JOB_KEY, VERSION) values (?, ?, ?, ?)";
    private static final String FIND_JOBS_WITH_NAME = "SELECT JOB_INSTANCE_ID, JOB_NAME from %PREFIX%JOB_INSTANCE where JOB_NAME = ?";
    private static final String FIND_JOBS_WITH_KEY = "SELECT JOB_INSTANCE_ID, JOB_NAME from %PREFIX%JOB_INSTANCE where JOB_NAME = ? and JOB_KEY = ?";
    private static final String COUNT_JOBS_WITH_NAME = "SELECT COUNT(*) from %PREFIX%JOB_INSTANCE where JOB_NAME = ?";
    private static final String FIND_JOBS_WITH_EMPTY_KEY = "SELECT JOB_INSTANCE_ID, JOB_NAME from %PREFIX%JOB_INSTANCE where JOB_NAME = ? and (JOB_KEY = ? OR JOB_KEY is NULL)";
    private static final String GET_JOB_FROM_ID = "SELECT JOB_INSTANCE_ID, JOB_NAME, JOB_KEY, VERSION from %PREFIX%JOB_INSTANCE where JOB_INSTANCE_ID = ?";
    private static final String GET_JOB_FROM_EXECUTION_ID = "SELECT ji.JOB_INSTANCE_ID, JOB_NAME, JOB_KEY, ji.VERSION from %PREFIX%JOB_INSTANCE ji, %PREFIX%JOB_EXECUTION je where JOB_EXECUTION_ID = ? and ji.JOB_INSTANCE_ID = je.JOB_INSTANCE_ID";
    private static final String FIND_JOB_NAMES = "SELECT distinct JOB_NAME from %PREFIX%JOB_INSTANCE order by JOB_NAME";
    private static final String FIND_LAST_JOBS_BY_NAME = "SELECT JOB_INSTANCE_ID, JOB_NAME from %PREFIX%JOB_INSTANCE where JOB_NAME = ? order by JOB_INSTANCE_ID desc";
    private static final String FIND_LAST_JOBS_LIKE_NAME = "SELECT JOB_INSTANCE_ID, JOB_NAME from %PREFIX%JOB_INSTANCE where JOB_NAME like ? order by JOB_INSTANCE_ID desc";
    private DataFieldMaxValueIncrementer jobIncrementer;
    private JobKeyGenerator<JobParameters> jobKeyGenerator = new DefaultJobKeyGenerator();

    public JobInstance createJobInstance(String jobName, JobParameters jobParameters) {
        Assert.notNull((Object)jobName, (String)"Job name must not be null.");
        Assert.notNull((Object)jobParameters, (String)"JobParameters must not be null.");
        Assert.state((this.getJobInstance(jobName, jobParameters) == null ? 1 : 0) != 0, (String)"JobInstance must not already exist");
        Long jobId = this.jobIncrementer.nextLongValue();
        JobInstance jobInstance = new JobInstance(jobId, jobName);
        jobInstance.incrementVersion();
        Object[] parameters = new Object[]{jobId, jobName, this.jobKeyGenerator.generateKey((Object)jobParameters), jobInstance.getVersion()};
        this.getJdbcTemplate().update(this.getQuery(CREATE_JOB_INSTANCE), parameters, new int[]{-5, 12, 12, 4});
        return jobInstance;
    }

    public JobInstance getJobInstance(String jobName, JobParameters jobParameters) {
        Assert.notNull((Object)jobName, (String)"Job name must not be null.");
        Assert.notNull((Object)jobParameters, (String)"JobParameters must not be null.");
        String jobKey = this.jobKeyGenerator.generateKey((Object)jobParameters);
        JobInstanceRowMapper rowMapper = new JobInstanceRowMapper();
        List instances = StringUtils.hasLength((String)jobKey) ? this.getJdbcTemplate().query(this.getQuery(FIND_JOBS_WITH_KEY), (RowMapper)rowMapper, new Object[]{jobName, jobKey}) : this.getJdbcTemplate().query(this.getQuery(FIND_JOBS_WITH_EMPTY_KEY), (RowMapper)rowMapper, new Object[]{jobName, jobKey});
        if (instances.isEmpty()) {
            return null;
        }
        Assert.state((instances.size() == 1 ? 1 : 0) != 0);
        return (JobInstance)instances.get(0);
    }

    public JobInstance getJobInstance(Long instanceId) {
        try {
            return (JobInstance)this.getJdbcTemplate().queryForObject(this.getQuery(GET_JOB_FROM_ID), (RowMapper)new JobInstanceRowMapper(), new Object[]{instanceId});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public List<String> getJobNames() {
        return this.getJdbcTemplate().query(this.getQuery(FIND_JOB_NAMES), (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString(1);
            }
        });
    }

    public List<JobInstance> getJobInstances(String jobName, final int start, final int count) {
        ResultSetExtractor<List<JobInstance>> extractor = new ResultSetExtractor<List<JobInstance>>(){
            private List<JobInstance> list = new ArrayList<JobInstance>();

            public List<JobInstance> extractData(ResultSet rs) throws SQLException, DataAccessException {
                int rowNum;
                for (rowNum = 0; rowNum < start && rs.next(); ++rowNum) {
                }
                while (rowNum < start + count && rs.next()) {
                    JobInstanceRowMapper rowMapper = new JobInstanceRowMapper();
                    this.list.add((JobInstance)rowMapper.mapRow(rs, rowNum));
                    ++rowNum;
                }
                return this.list;
            }
        };
        List result = (List)this.getJdbcTemplate().query(this.getQuery(FIND_LAST_JOBS_BY_NAME), new Object[]{jobName}, (ResultSetExtractor)extractor);
        return result;
    }

    public JobInstance getJobInstance(JobExecution jobExecution) {
        try {
            return (JobInstance)this.getJdbcTemplate().queryForObject(this.getQuery(GET_JOB_FROM_EXECUTION_ID), (RowMapper)new JobInstanceRowMapper(), new Object[]{jobExecution.getId()});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public int getJobInstanceCount(String jobName) throws NoSuchJobException {
        try {
            return (Integer)this.getJdbcTemplate().queryForObject(this.getQuery(COUNT_JOBS_WITH_NAME), Integer.class, new Object[]{jobName});
        }
        catch (EmptyResultDataAccessException e) {
            throw new NoSuchJobException("No job instances were found for job name " + jobName);
        }
    }

    public void setJobIncrementer(DataFieldMaxValueIncrementer jobIncrementer) {
        this.jobIncrementer = jobIncrementer;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.jobIncrementer);
    }

    public List<JobInstance> findJobInstancesByName(String jobName, final int start, final int count) {
        ResultSetExtractor extractor = new ResultSetExtractor(){
            private List<JobInstance> list = new ArrayList<JobInstance>();

            public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
                int rowNum;
                for (rowNum = 0; rowNum < start && rs.next(); ++rowNum) {
                }
                while (rowNum < start + count && rs.next()) {
                    JobInstanceRowMapper rowMapper = new JobInstanceRowMapper();
                    this.list.add((JobInstance)rowMapper.mapRow(rs, rowNum));
                    ++rowNum;
                }
                return this.list;
            }
        };
        if (jobName.contains(STAR_WILDCARD)) {
            jobName = jobName.replaceAll("\\*", SQL_WILDCARD);
        }
        List result = (List)this.getJdbcTemplate().query(this.getQuery(FIND_LAST_JOBS_LIKE_NAME), new Object[]{jobName}, extractor);
        return result;
    }

    private final class JobInstanceRowMapper
    implements RowMapper<JobInstance> {
        public JobInstance mapRow(ResultSet rs, int rowNum) throws SQLException {
            JobInstance jobInstance = new JobInstance(Long.valueOf(rs.getLong(1)), rs.getString(2));
            jobInstance.incrementVersion();
            return jobInstance;
        }
    }
}

