/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.backend.sparql;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.batch.backend.sparql.CollectionOpsExecutionContext;
import org.aksw.jena_sparql_api.batch.backend.sparql.DefaultIriAnnotation;
import org.aksw.jena_sparql_api.batch.backend.sparql.FunctionMemoize;
import org.aksw.jena_sparql_api.batch.backend.sparql.IriAnnotation;
import org.aksw.jena_sparql_api.batch.backend.sparql.JobExecution;
import org.aksw.jena_sparql_api.batch.backend.sparql.MapExecutionContext;
import org.aksw.jena_sparql_api.beans.model.CollectionOps;
import org.aksw.jena_sparql_api.beans.model.EntityModel;
import org.aksw.jena_sparql_api.beans.model.EntityOps;
import org.aksw.jena_sparql_api.beans.model.PropertyModel;
import org.aksw.jena_sparql_api.core.SparqlService;
import org.aksw.jena_sparql_api.mapper.annotation.DefaultIri;
import org.aksw.jena_sparql_api.mapper.annotation.Iri;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfTypeFactoryImpl;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfTypeMap;
import org.aksw.jena_sparql_api.mapper.jpa.core.RdfEntityManager;
import org.aksw.jena_sparql_api.mapper.jpa.core.SparqlEntityManagerFactory;
import org.aksw.jena_sparql_api.mapper.model.RdfType;
import org.aksw.jena_sparql_api.mapper.model.RdfTypeFactory;
import org.aksw.jena_sparql_api.mapper.util.BeanUtils;
import org.aksw.jena_sparql_api.sparql.ext.datatypes.RDFDatatypeDate;
import org.aksw.jena_sparql_api.update.FluentSparqlService;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Model;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.context.support.ConversionServiceFactoryBean;
import org.springframework.core.convert.ConversionService;

public class SpringBatchMappings {
    public static <I, O> Function<I, O> memoize(Function<I, O> fn) {
        HashMap cache = new HashMap();
        Function<Object, Object> result = i -> cache.computeIfAbsent(i, fn);
        return result;
    }

    public static void test() {
        ConversionServiceFactoryBean bean = new ConversionServiceFactoryBean();
        bean.afterPropertiesSet();
        ConversionService cs = bean.getObject();
        Long value = 1L;
        TypeMapper tm = TypeMapper.getInstance();
        RDFDatatype dt = tm.getTypeByClass(value.getClass());
        String lex = dt.unparse((Object)value);
        Node node = NodeFactory.createLiteral((String)lex, (RDFDatatype)dt);
        Object o = dt.parse(lex);
        System.out.println(o.getClass());
        Object x = node.getLiteralValue();
        System.out.println("Got value: " + x.getClass() + " " + node);
    }

    public static void main(String[] args) throws Exception {
        EntityModel.createDefaultModel(Boolean.class, null);
        ConversionServiceFactoryBean bean = new ConversionServiceFactoryBean();
        bean.afterPropertiesSet();
        ConversionService conversionService = bean.getObject();
        TypeMapper tm = TypeMapper.getInstance();
        tm.registerDatatype((RDFDatatype)new RDFDatatypeDate());
        HashMap<Class, EntityModel> customOps = new HashMap<Class, EntityModel>();
        HashSet<String> excludeProperties = new HashSet<String>(Arrays.asList("executionContext", "exitStatus", "status"));
        Map<String, String> pmap = BeanUtils.getPropertyNames((Object)new ExecutionContext()).stream().filter(p -> !excludeProperties.contains(p)).collect(Collectors.toMap(e -> e, e -> "http://batch.aksw.org/ontology/" + e));
        EntityModel entityModel = EntityModel.createDefaultModel(ExecutionContext.class, (ConversionService)conversionService);
        entityModel.setAnnotationFinder(clazz -> {
            if (clazz.equals(DefaultIri.class)) {
                DefaultIriAnnotation x = new DefaultIriAnnotation("http://ex.org/#{id}");
                return x;
            }
            return null;
        });
        for (PropertyModel pm : entityModel.getProperties()) {
            pm.setAnnotationFinder(clazz -> {
                String str;
                if (clazz.equals(Iri.class) && (str = (String)pmap.get(pm.getName())) != null) {
                    IriAnnotation x = new IriAnnotation(str);
                    return x;
                }
                return null;
            });
        }
        excludeProperties = new HashSet<String>(Arrays.asList("exitStatus", "status"));
        pmap = BeanUtils.getPropertyNames((Object)new JobExecution(0L)).stream().filter(p -> !excludeProperties.contains(p)).collect(Collectors.toMap(e -> e, e -> "http://batch.aksw.org/ontology/" + e));
        entityModel = EntityModel.createDefaultModel(JobExecution.class, (ConversionService)conversionService);
        entityModel.setNewInstance(() -> new JobExecution(0L));
        entityModel.setAnnotationFinder(clazz -> {
            if (clazz.equals(DefaultIri.class)) {
                DefaultIriAnnotation x = new DefaultIriAnnotation("http://ex.org/#{id}");
                return x;
            }
            return null;
        });
        for (PropertyModel pm : entityModel.getProperties()) {
            pm.setAnnotationFinder(clazz -> {
                String str;
                if (pm.getName().equals("executionContext") && clazz.equals(DefaultIri.class)) {
                    return new DefaultIriAnnotation("http://ex.org/foobar/#{id}");
                }
                if (clazz.equals(Iri.class) && (str = (String)pmap.get(pm.getName())) != null) {
                    IriAnnotation x = new IriAnnotation(str);
                    return x;
                }
                return null;
            });
        }
        JobExecution inst = (JobExecution)entityModel.newInstance();
        entityModel.getProperty("id").setValue((Object)inst, (Object)12L);
        customOps.put(JobExecution.class, entityModel);
        EntityModel ecModel = EntityModel.createDefaultModel(ExecutionContext.class, (ConversionService)conversionService);
        ecModel.setCollectionOps((CollectionOps)new CollectionOpsExecutionContext());
        customOps.put(ExecutionContext.class, ecModel);
        FunctionMemoize<Class, EntityOps> classToOps = new FunctionMemoize<Class, EntityOps>(clazz -> EntityModel.createDefaultModel((Class)clazz, (ConversionService)conversionService));
        classToOps.getCache().putAll(customOps);
        RdfTypeFactoryImpl typeFactory = RdfTypeFactoryImpl.createDefault(null, classToOps, (ConversionService)conversionService);
        typeFactory.getClassToRdfType().put(ExecutionContext.class, new RdfTypeMap(MapExecutionContext::createMapView));
        RdfType t = typeFactory.forJavaType(JobExecution.class);
        SparqlService sparqlService = (SparqlService)FluentSparqlService.forModel().create();
        RdfEntityManager em = SparqlEntityManagerFactory.newInstance().setSparqlService(sparqlService).setTypeFactory((RdfTypeFactory)typeFactory).getObject();
        JobExecution entity = new JobExecution(11L);
        ExecutionContext ec = new ExecutionContext();
        ec.put("hello", (Object)"world");
        ec.put("foo", (Object)666);
        entity.setExecutionContext(ec);
        em.merge((Object)entity);
        Model model = sparqlService.getQueryExecutionFactory().createQueryExecution("CONSTRUCT WHERE { ?s ?p ?o }").execConstruct();
        System.out.println("Graph:");
        model.write((OutputStream)System.out, "TTL");
        JobExecution lr = (JobExecution)em.find(JobExecution.class, (Object)NodeFactory.createURI((String)"http://ex.org/11"));
        System.out.println("Lookup result: " + lr);
        em.merge((Object)lr);
        System.out.println("Graph:");
        sparqlService.getQueryExecutionFactory().createQueryExecution("CONSTRUCT WHERE { ?s ?p ?o }").execConstruct().write((OutputStream)System.out, "TTL");
        System.out.println("Lookup result: " + em.find(JobExecution.class, (Object)NodeFactory.createURI((String)"http://ex.org/11")));
    }
}

