/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.config;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import org.aksw.jena_sparql_api.core.SparqlService;
import org.aksw.jena_sparql_api.core.SparqlServiceFactory;
import org.aksw.jena_sparql_api.sparql.ext.http.HttpInterceptorRdfLogging;
import org.aksw.jena_sparql_api.update.DatasetListenerTrack;
import org.aksw.jena_sparql_api.update.SinkModelWriter;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.jena.atlas.lib.Sink;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class ConfigSparqlServicesCore {
    private Random random = new Random();

    @Bean
    @Autowired
    @Primary
    public SparqlServiceFactory workflowSparqlServiceFactory(@Qualifier(value="config") SparqlServiceFactory ssf, @Qualifier(value="tracking") SparqlService trackerService) {
        long jobInstanceId = this.random.nextLong();
        DatasetListenerTrack listener = new DatasetListenerTrack(trackerService);
        List<DatasetListenerTrack> listeners = Collections.singletonList(listener);
        SparqlServiceFactory result = ssf;
        return result;
    }

    @Bean
    @Autowired
    public Supplier<HttpClient> httpClientSupplier(@Qualifier(value="logging") SparqlService sparqlService) {
        SinkModelWriter sink = new SinkModelWriter(sparqlService);
        HttpInterceptorRdfLogging logger = new HttpInterceptorRdfLogging((Sink)sink);
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        connManager.setMaxTotal(100);
        connManager.setDefaultMaxPerRoute(100);
        CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connManager).addInterceptorLast((HttpRequestInterceptor)logger).addInterceptorLast((HttpResponseInterceptor)logger).build();
        Supplier<HttpClient> result = () -> ConfigSparqlServicesCore.lambda$httpClientSupplier$0((HttpClient)httpClient);
        return result;
    }

    private static /* synthetic */ HttpClient lambda$httpClientSupplier$0(HttpClient httpClient) {
        return httpClient;
    }
}

