/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.json.rewriters;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.aksw.gson.utils.JsonUtils;
import org.aksw.gson.utils.JsonVisitorRewrite;
import org.aksw.jena_sparql_api.hop.Hop;
import org.aksw.jena_sparql_api.hop.HopQuery;
import org.aksw.jena_sparql_api.hop.HopRelation;

public class JsonVisitorRewriteHop
extends JsonVisitorRewrite {
    public JsonElement visit(JsonObject json) {
        JsonObject result;
        if (json.has("$hop")) {
            JsonElement data = json.get("$hop");
            result = JsonVisitorRewriteHop.processHop(data);
        } else {
            result = json;
        }
        return result;
    }

    public static JsonElement processHops(JsonElement json) {
        JsonArray src = json.isJsonArray() ? json.getAsJsonArray() : JsonUtils.singletonArray((JsonElement)json);
        JsonArray result = new JsonArray();
        for (JsonElement item : src) {
            JsonElement tmp = JsonVisitorRewriteHop.processHop(item);
            result.add(tmp);
        }
        return result;
    }

    public static JsonElement processHop(JsonElement json) {
        JsonElement result = JsonVisitorRewriteHop.processHopCore(json);
        return result;
    }

    public static JsonElement processHopCore(JsonElement json) {
        JsonObject obj = json.getAsJsonObject();
        JsonElement tmpQueries = obj.get("queries");
        JsonElement tmpRelations = obj.get("relations");
        JsonElement queries = JsonVisitorRewriteHop.processQueries(tmpQueries);
        JsonElement relations = JsonVisitorRewriteHop.processRelations(tmpRelations);
        JsonArray ctorArgs = new JsonArray();
        ctorArgs.add(queries);
        ctorArgs.add(relations);
        JsonObject result = new JsonObject();
        result.addProperty("type", Hop.class.getName());
        result.add("ctor", (JsonElement)ctorArgs);
        return result;
    }

    public static JsonElement processQueries(JsonElement json) {
        boolean isShortcut = JsonVisitorRewriteHop.isQueryShortcut(json);
        JsonArray src = isShortcut ? JsonUtils.singletonArray((JsonElement)json) : JsonVisitorRewriteHop.safeArray(json);
        JsonArray result = new JsonArray();
        for (JsonElement tmpItem : src) {
            JsonElement item = JsonVisitorRewriteHop.processQuery(tmpItem);
            result.add(item);
        }
        return result;
    }

    public static boolean isQueryShortcut(JsonElement json) {
        JsonArray arr;
        boolean isQueryShortcut = false;
        if (json != null && json.isJsonArray() && (arr = json.getAsJsonArray()).size() <= 2) {
            JsonElement a = JsonUtils.safeGet((JsonArray)arr, (int)0);
            JsonElement b = JsonUtils.safeGet((JsonArray)arr, (int)1);
            if (a.isJsonPrimitive() && b.isJsonPrimitive()) {
                isQueryShortcut = true;
            }
        }
        return isQueryShortcut;
    }

    public static boolean isRelationShortcut(JsonElement json) {
        JsonArray arr;
        boolean isQueryShortcut = false;
        if (json != null && json.isJsonArray() && (arr = json.getAsJsonArray()).size() <= 3) {
            JsonElement a = JsonUtils.safeGet((JsonArray)arr, (int)0);
            JsonElement b = JsonUtils.safeGet((JsonArray)arr, (int)1);
            if (a.isJsonPrimitive() && b.isJsonPrimitive()) {
                isQueryShortcut = true;
            }
        }
        return isQueryShortcut;
    }

    public static JsonElement processQuery(JsonElement json) {
        JsonObject obj;
        if (json.isJsonPrimitive()) {
            obj = new JsonObject();
            obj.add("query", json);
        } else if (json.isJsonArray()) {
            JsonArray arr = json.getAsJsonArray();
            obj = new JsonObject();
            obj.add("query", JsonUtils.safeGet((JsonArray)arr, (int)0));
            obj.add("on", JsonUtils.safeGet((JsonArray)arr, (int)1));
        } else {
            obj = json.getAsJsonObject();
        }
        JsonElement result = JsonVisitorRewriteHop.processQueryCore(obj);
        return result;
    }

    public static JsonElement processQueryCore(JsonObject json) {
        JsonElement query = json.get("query");
        JsonElement on = json.get("on");
        JsonArray ctorArgs = new JsonArray();
        ctorArgs.add(query);
        ctorArgs.add(on);
        JsonObject result = new JsonObject();
        result.addProperty("type", HopQuery.class.getName());
        result.add("ctor", (JsonElement)ctorArgs);
        return result;
    }

    public static JsonObject expandRelationShortuct(JsonArray arr) {
        JsonElement hops;
        JsonElement on;
        JsonElement relation = JsonUtils.safeGet((JsonArray)arr, (int)0);
        if (arr.size() == 2) {
            on = null;
            hops = JsonUtils.safeGet((JsonArray)arr, (int)1);
        } else {
            on = JsonUtils.safeGet((JsonArray)arr, (int)1);
            hops = JsonUtils.safeGet((JsonArray)arr, (int)2);
        }
        JsonObject result = new JsonObject();
        result.add("via", relation);
        result.add("on", on);
        result.add("hops", hops);
        return result;
    }

    public static JsonArray safeArray(JsonElement json) {
        JsonArray result;
        if (json == null || json.isJsonNull()) {
            result = new JsonArray();
        } else if (json.isJsonArray()) {
            result = json.getAsJsonArray();
        } else {
            throw new RuntimeException("Array expected, instead got: " + json);
        }
        return result;
    }

    public static JsonElement processRelations(JsonElement json) {
        boolean isShortcut = JsonVisitorRewriteHop.isRelationShortcut(json);
        JsonArray src = isShortcut ? JsonUtils.singletonArray((JsonElement)json) : JsonVisitorRewriteHop.safeArray(json);
        JsonArray result = new JsonArray();
        for (JsonElement tmpItem : src) {
            JsonElement item = JsonVisitorRewriteHop.processRelation(tmpItem);
            result.add(item);
        }
        return result;
    }

    public static JsonElement processRelation(JsonElement json) {
        JsonObject tmpObj = json.isJsonArray() ? JsonVisitorRewriteHop.expandRelationShortuct(json.getAsJsonArray()) : json.getAsJsonObject();
        JsonElement result = JsonVisitorRewriteHop.processRelationCore(tmpObj);
        return result;
    }

    public static JsonElement processRelationCore(JsonObject json) {
        JsonElement via = json.get("via");
        JsonElement on = json.get("on");
        JsonElement tmpHops = json.get("hops");
        JsonElement hops = JsonVisitorRewriteHop.processHop(tmpHops);
        JsonArray ctorArgs = new JsonArray();
        ctorArgs.add(on);
        ctorArgs.add(via);
        ctorArgs.add(hops);
        JsonObject result = new JsonObject();
        result.addProperty("type", HopRelation.class.getName());
        result.add("ctor", (JsonElement)ctorArgs);
        return result;
    }
}

