/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.processor;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.SetUtils;
import org.aksw.commons.collections.diff.Diff;
import org.aksw.jena_sparql_api.modifier.Modifier;
import org.aksw.jena_sparql_api.utils.SetDatasetGraph;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.springframework.batch.item.ItemProcessor;

public class ItemProcessorDatasetDiff
implements ItemProcessor<Map.Entry<Resource, Dataset>, Diff<Set<Quad>>> {
    private Modifier<Dataset> modifier;

    public ItemProcessorDatasetDiff(Modifier<Dataset> modifier) {
        this.modifier = modifier;
    }

    public Diff<Set<Quad>> process(Map.Entry<Resource, Dataset> entry) throws Exception {
        Dataset base = entry.getValue();
        DatasetGraph baseGraph = base.asDatasetGraph();
        DatasetGraph cloneGraph = DatasetGraphFactory.createGeneral();
        Iterator it = baseGraph.find();
        while (it.hasNext()) {
            Quad q = (Quad)it.next();
            cloneGraph.add(q);
        }
        Dataset clone = DatasetFactory.wrap((DatasetGraph)cloneGraph);
        this.modifier.apply(clone);
        SetDatasetGraph baseQuads = SetDatasetGraph.wrap((DatasetGraph)base.asDatasetGraph());
        SetDatasetGraph cloneQuads = SetDatasetGraph.wrap((DatasetGraph)clone.asDatasetGraph());
        Diff result = ItemProcessorDatasetDiff.createDiff(baseQuads, cloneQuads);
        return result;
    }

    public static <T> Diff<Set<T>> createDiff(Collection<T> before, Collection<T> after) {
        Set x = SetUtils.asSet(before);
        Set y = SetUtils.asSet(after);
        HashSet added = new HashSet(Sets.difference((Set)x, (Set)y));
        HashSet removed = new HashSet(Sets.difference((Set)y, (Set)x));
        Diff result = Diff.create(added, removed);
        return result;
    }
}

