/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.processor;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.concepts.Path;
import org.aksw.jena_sparql_api.concepts.Step;
import org.aksw.jena_sparql_api.geo.GeoMapSupplierUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.update.Update;

class ModelUtils {
    ModelUtils() {
    }

    public static Update deleteByConcept(Concept concept) {
        return null;
    }

    public static void clearGeometryWgs(Model model) {
        Concept c = GeoMapSupplierUtils.conceptWgs84;
        String wgs = "PREFIX geo: <http://www.w3.org/2003/01/geo/wgs84_pos#> DELETE WHERE { ?s geo:long ?x ; geo:lat ?y }";
        String wgsGeometry = "PREFIX geo: <http://www.w3.org/2003/01/geo/wgs84_pos#> DELETE WHERE { ?s geo:geometry ?y }";
        String geoSparqlLiteral = "PREFIX sp: <http://www.opengis.net/ont/geosparql#> DELETE WHERE { ?s sp:asWKT ?w }";
    }

    public static Set<RDFNode> getNodes(Model model, RDFNode first, Path path) {
        List steps = path.getSteps();
        Set<RDFNode> starts = Collections.singleton(first);
        for (Step step : steps) {
            String propertyName = step.getPropertyName();
            boolean isInverse = step.isInverse();
            Property property = model.createProperty(propertyName);
            HashSet<RDFNode> nodes = new HashSet<RDFNode>();
            for (RDFNode start : starts) {
                HashSet tmp = !isInverse ? model.listObjectsOfProperty(start.asResource(), property).toSet() : (start.isResource() ? new HashSet(model.listSubjectsWithProperty(property, start).toSet()) : Collections.emptySet());
                nodes.addAll(tmp);
            }
            starts = nodes;
        }
        return starts;
    }
}

