/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.reader;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aksw.jena_sparql_api.batch.step.F_TripleToQuad;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.pagination.core.PagingQuery;
import org.aksw.jena_sparql_api.pagination.extra.PaginationQueryIterator;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.sparql.core.Quad;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.data.AbstractPaginatedDataItemReader;
import org.springframework.beans.factory.InitializingBean;

public class ItemReaderQuad
extends AbstractPaginatedDataItemReader<Quad>
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(ItemReaderQuad.class);
    private Query query;
    private QueryExecutionFactory qef;
    public static int nextId = 0;
    private int id;

    public ItemReaderQuad() {
        this.setName(((Object)((Object)this)).getClass().getName());
        this.id = ++nextId;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public QueryExecutionFactory getQef() {
        return this.qef;
    }

    public void setQef(QueryExecutionFactory qef) {
        this.qef = qef;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public ItemReaderQuad(QueryExecutionFactory qef, Query query) {
        this.setName(((Object)((Object)this)).getClass().getName());
        this.qef = qef;
        this.query = query;
    }

    protected Iterator<Quad> doPageRead() {
        long offset = this.page * this.pageSize;
        logger.info("[START] ItemReader " + this.id + " on page " + this.page);
        PagingQuery pagingQuery = new PagingQuery(Integer.valueOf(this.pageSize), this.query);
        PaginationQueryIterator itQuery = pagingQuery.createQueryIterator(Long.valueOf(offset), null);
        Query query = (Query)itQuery.next();
        if (query == null) {
            List tmp = Collections.emptyList();
            return tmp.iterator();
        }
        QueryExecution qe = this.qef.createQueryExecution(query);
        Iterator triplesIt = qe.execConstructTriples();
        Iterator result = Iterators.transform((Iterator)triplesIt, (Function)F_TripleToQuad.fn);
        logger.info("[DONE] ItemReader " + this.id + " on page " + this.page);
        return result;
    }
}

