/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.step;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class FactoryBeanSimpleJob
extends AbstractFactoryBean<Job> {
    @Autowired
    protected JobBuilderFactory jobBuilders;
    protected String name;
    protected List<Step> steps = new ArrayList<Step>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    public Class<?> getObjectType() {
        return Job.class;
    }

    protected Job createInstance() throws Exception {
        if (this.steps.isEmpty()) {
            throw new RuntimeException("Job does not have any steps");
        }
        JobBuilder jobBuilder = this.jobBuilders.get(this.name);
        Step firstStep = this.steps.get(0);
        SimpleJobBuilder flow = jobBuilder.start(firstStep);
        for (int i = 1; i < this.steps.size(); ++i) {
            Step step = this.steps.get(i);
            if (step == null) {
                throw new RuntimeException("Got 'null' step" + this.steps);
            }
            if (step.getName() == null) {
                throw new RuntimeException("Got step without name: " + step);
            }
            flow.next(step);
        }
        Job result = flow.build();
        return result;
    }
}

