/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.step;

import java.util.List;
import org.aksw.jena_sparql_api.batch.processor.ItemProcessorModifierDatasetGraphDiff;
import org.aksw.jena_sparql_api.batch.reader.ItemReaderDatasetGraph;
import org.aksw.jena_sparql_api.batch.writer.ItemWriterSparqlDiff;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.SparqlService;
import org.aksw.jena_sparql_api.core.UpdateExecutionFactory;
import org.aksw.jena_sparql_api.hop.Hop;
import org.aksw.jena_sparql_api.hop.MapServiceHop;
import org.aksw.jena_sparql_api.lookup.MapService;
import org.aksw.jena_sparql_api.modifier.Modifier;
import org.aksw.jena_sparql_api.modifier.ModifierList;
import org.aksw.jena_sparql_api.shape.ResourceShape;
import org.aksw.jena_sparql_api.shape.ResourceShapeParser;
import org.aksw.jena_sparql_api.shape.lookup.MapServiceResourceShapeDataset;
import org.aksw.jena_sparql_api.stmt.SparqlUpdateParser;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class FactoryBeanStepSparqlDiff
extends AbstractFactoryBean<Step> {
    protected StepBuilderFactory stepBuilders;
    protected ResourceShape shape;
    protected Hop hop;
    protected String name;
    protected int chunkSize;
    protected QueryExecutionFactory sourceQef;
    protected Concept concept;
    protected SparqlUpdateParser updateParser;
    @Autowired
    protected ResourceShapeParser shapeParser;
    protected List<Modifier<? super DatasetGraph>> modifiers;
    protected UpdateExecutionFactory targetUef;

    public FactoryBeanStepSparqlDiff() {
        this.setSingleton(false);
    }

    @Autowired
    public void setStepBuilders(StepBuilderFactory stepBuilders) {
        this.stepBuilders = stepBuilders;
    }

    @Autowired
    public void setSparqlUpdateParser(SparqlUpdateParser updateParser) {
        this.updateParser = updateParser;
    }

    public FactoryBeanStepSparqlDiff setChunk(int chunkSize) {
        this.chunkSize = chunkSize;
        return this;
    }

    public FactoryBeanStepSparqlDiff setShape(ResourceShape shape) {
        this.shape = shape;
        return this;
    }

    public FactoryBeanStepSparqlDiff setHop(Hop hop) {
        this.hop = hop;
        return this;
    }

    public FactoryBeanStepSparqlDiff setModifiers(List<Modifier<? super DatasetGraph>> modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    public FactoryBeanStepSparqlDiff setName(String name) {
        this.name = name;
        return this;
    }

    public FactoryBeanStepSparqlDiff setSource(QueryExecutionFactory sourceQef) {
        this.sourceQef = sourceQef;
        return this;
    }

    public FactoryBeanStepSparqlDiff setConcept(Concept concept) {
        this.concept = concept;
        return this;
    }

    public FactoryBeanStepSparqlDiff setTarget(UpdateExecutionFactory targetUef) {
        this.targetUef = targetUef;
        return this;
    }

    public FactoryBeanStepSparqlDiff setService(SparqlService sparqlService) {
        this.sourceQef = sparqlService.getQueryExecutionFactory();
        this.targetUef = sparqlService.getUpdateExecutionFactory();
        return this;
    }

    public String getName() {
        return this.name;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public QueryExecutionFactory getSource() {
        return this.sourceQef;
    }

    public Concept getConcept() {
        return this.concept;
    }

    public List<Modifier<? super DatasetGraph>> getModifiers() {
        return this.modifiers;
    }

    public UpdateExecutionFactory getTarget() {
        return this.targetUef;
    }

    public MapService<Concept, Node, DatasetGraph> createListService() {
        MapServiceHop result;
        ResourceShape sh = this.shape;
        if (this.hop != null) {
            result = new MapServiceHop(this.sourceQef, this.hop, 30);
        } else if (sh != null) {
            result = new MapServiceResourceShapeDataset(this.sourceQef, sh, true);
        } else {
            throw new RuntimeException("No shape provided");
        }
        return result;
    }

    public Step createInstance() throws Exception {
        ModifierList<? super DatasetGraph> modifier = ModifierList.create(this.modifiers);
        MapService<Concept, Node, DatasetGraph> listService = this.createListService();
        ItemReaderDatasetGraph itemReader = new ItemReaderDatasetGraph(listService, this.concept);
        ItemProcessorModifierDatasetGraphDiff itemProcessor = new ItemProcessorModifierDatasetGraphDiff(modifier);
        ItemWriterSparqlDiff itemWriter = new ItemWriterSparqlDiff(this.targetUef);
        itemReader.setPageSize(this.chunkSize);
        StepBuilder stepBuilder = this.stepBuilders.get(this.name);
        TaskletStep result = stepBuilder.chunk(this.chunkSize).reader((ItemReader)itemReader).processor((ItemProcessor)itemProcessor).writer((ItemWriter)itemWriter).build();
        return result;
    }

    public Class<?> getObjectType() {
        return Step.class;
    }
}

