/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.step;

import org.aksw.jena_sparql_api.batch.reader.ItemReaderQuad;
import org.aksw.jena_sparql_api.batch.reader.PredicateQuadExpr;
import org.aksw.jena_sparql_api.batch.step.FactoryBeanStepBase;
import org.aksw.jena_sparql_api.batch.step.PartitionerSparqlSlice;
import org.aksw.jena_sparql_api.batch.step.ValidatorQuadByPredicate;
import org.aksw.jena_sparql_api.batch.writer.ItemWriterQuad;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.UpdateExecutionFactory;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.expr.Expr;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.partition.support.Partitioner;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.support.PassThroughItemProcessor;
import org.springframework.batch.item.validator.ValidatingItemProcessor;
import org.springframework.batch.item.validator.Validator;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ConfigurableApplicationContext;

public class FactoryBeanStepSparqlPipe
extends FactoryBeanStepBase {
    protected int chunkSize = 1000;
    protected int readSize = 1000;
    protected Query query;
    protected boolean isDelete;
    protected QueryExecutionFactory source;
    protected UpdateExecutionFactory target;
    protected Expr filter;

    public FactoryBeanStepSparqlPipe() {
        this.setSingleton(false);
    }

    public FactoryBeanStepSparqlPipe setName(String name) {
        super.setName(name);
        return this;
    }

    public FactoryBeanStepSparqlPipe setChunk(int chunkSize) {
        this.chunkSize = chunkSize;
        return this;
    }

    public int getReadSize() {
        return this.readSize;
    }

    public void setReadSize(int readSize) {
        this.readSize = readSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public QueryExecutionFactory getSource() {
        return this.source;
    }

    public void setSource(QueryExecutionFactory source) {
        this.source = source;
    }

    public UpdateExecutionFactory getTarget() {
        return this.target;
    }

    public void setTarget(UpdateExecutionFactory target) {
        this.target = target;
    }

    public Expr getFilter() {
        return this.filter;
    }

    public void setFilter(Expr filter) {
        this.filter = filter;
    }

    public boolean isDelete() {
        return this.isDelete;
    }

    public void setDelete(boolean isDelete) {
        this.isDelete = isDelete;
    }

    @Override
    protected Step configureStep(StepBuilder stepBuilder) {
        PassThroughItemProcessor processor;
        PredicateQuadExpr predicate;
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)((ConfigurableApplicationContext)this.ctx).getBeanFactory();
        RootBeanDefinition itemReaderBd = new RootBeanDefinition(ItemReaderQuad.class);
        itemReaderBd.setScope("step");
        itemReaderBd.getPropertyValues().add("currentItemCount", (Object)"#{ stepExecutionContext[minValue] }").add("maxItemCount", (Object)"#{ stepExecutionContext[maxValue] }").add("pageSize", (Object)this.readSize).add("qef", (Object)this.source).add("query", (Object)this.query);
        String itemReaderName = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)itemReaderBd, (BeanDefinitionRegistry)beanFactory);
        BeanDefinitionHolder proxyHolder = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)new BeanDefinitionHolder((BeanDefinition)itemReaderBd, itemReaderName), (BeanDefinitionRegistry)beanFactory, (boolean)true);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)proxyHolder, (BeanDefinitionRegistry)beanFactory);
        String proxyName = proxyHolder.getBeanName();
        ItemReader reader = (ItemReader)beanFactory.getBean(proxyName);
        PredicateQuadExpr predicateQuadExpr = predicate = this.filter == null ? null : new PredicateQuadExpr(this.filter);
        if (predicate != null) {
            ValidatingItemProcessor validatingProcessor = new ValidatingItemProcessor();
            validatingProcessor.setValidator((Validator)new ValidatorQuadByPredicate(predicate));
            validatingProcessor.setFilter(true);
            try {
                validatingProcessor.afterPropertiesSet();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            processor = validatingProcessor;
        } else {
            processor = new PassThroughItemProcessor();
        }
        ItemWriterQuad writer = new ItemWriterQuad(this.target, this.isDelete);
        TaskletStep result = stepBuilder.chunk(this.chunkSize).reader(reader).processor((ItemProcessor)processor).writer((ItemWriter)writer).build();
        if (this.throttle != null) {
            TaskletStep slaveStep = result;
            PartitionerSparqlSlice partitioner = new PartitionerSparqlSlice(this.source, this.query);
            result = stepBuilder.partitioner((Step)slaveStep).partitioner(this.name, (Partitioner)partitioner).taskExecutor(this.taskExecutor).gridSize(this.throttle.intValue()).build();
        }
        return result;
    }
}

