/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.convert;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.util.List;
import org.aksw.jena_sparql_api.convert.VocabReader;
import org.aksw.jena_sparql_api.geo.vocab.GEO;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;

public class VocabReaderWgs84
implements VocabReader<Geometry> {
    private GeometryFactory geometryFactory;

    public VocabReaderWgs84() {
        this(new GeometryFactory());
    }

    public VocabReaderWgs84(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    public static Double extractDouble(Object o) {
        Double result;
        if (o == null) {
            result = null;
        } else if (o instanceof Number) {
            Number n = (Number)o;
            result = n.doubleValue();
        } else {
            String str = o.toString();
            result = Double.parseDouble(str);
        }
        return result;
    }

    @Override
    public Geometry read(Model model, Resource base) {
        Point result;
        List xlongs = model.listObjectsOfProperty(base, GEO.xlong).toList();
        List lats = model.listObjectsOfProperty(base, GEO.lat).toList();
        if (xlongs.isEmpty() && lats.isEmpty()) {
            result = null;
        } else if (xlongs.size() == 1 && lats.size() == 1) {
            RDFNode xlong = (RDFNode)xlongs.get(0);
            RDFNode lat = (RDFNode)lats.get(0);
            Object ox = xlong.asLiteral().getValue();
            Object oy = lat.asLiteral().getValue();
            double x = VocabReaderWgs84.extractDouble(ox);
            double y = VocabReaderWgs84.extractDouble(oy);
            result = this.geometryFactory.createPoint(new Coordinate(x, y));
        } else {
            result = null;
        }
        return result;
    }
}

