/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.hop;

import com.google.common.base.Functions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.aksw.jena_sparql_api.concepts.BinaryRelation;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.utils.ReactiveSparqlUtils;
import org.aksw.jena_sparql_api.core.utils.ServiceUtils;
import org.aksw.jena_sparql_api.hop.Hop;
import org.aksw.jena_sparql_api.hop.HopQuery;
import org.aksw.jena_sparql_api.hop.HopRelation;
import org.aksw.jena_sparql_api.lookup.LookupService;
import org.aksw.jena_sparql_api.lookup.LookupServiceListService;
import org.aksw.jena_sparql_api.lookup.LookupServicePartition;
import org.aksw.jena_sparql_api.lookup.LookupServiceUtils;
import org.aksw.jena_sparql_api.lookup.MapPaginator;
import org.aksw.jena_sparql_api.lookup.MapService;
import org.aksw.jena_sparql_api.lookup.MapServiceUtils;
import org.aksw.jena_sparql_api.mapper.MappedQuery;
import org.aksw.jena_sparql_api.utils.DatasetGraphUtils;
import org.aksw.jena_sparql_api.utils.QueryUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;

public class MapPaginatorHop
implements MapPaginator<Node, DatasetGraph> {
    protected QueryExecutionFactory defaultQef;
    protected Hop root;
    protected Concept concept;
    public static int chunkSize = 30;

    public MapPaginatorHop(QueryExecutionFactory defaultQef, Hop root, Concept concept, int chunkSize) {
        this.defaultQef = defaultQef;
        this.root = root;
        this.concept = concept;
    }

    public Map<Node, DatasetGraph> fetchMap(Range<Long> range) {
        Long limit = QueryUtils.rangeToLimit(range);
        Long offset = QueryUtils.rangeToOffset(range);
        List sourceNodes = ServiceUtils.fetchList((QueryExecutionFactory)this.defaultQef, (Concept)this.concept, (Long)limit, (Long)offset);
        HashMap<Node, DatasetGraph> result = new HashMap<Node, DatasetGraph>();
        MapPaginatorHop.execRec(this.root, sourceNodes, result, this.defaultQef, null);
        return result;
    }

    public Single<Range<Long>> fetchCount(Long itemLimit, Long rowLimit) {
        Single result = ReactiveSparqlUtils.fetchCountConcept((QueryExecutionFactory)this.defaultQef, (Concept)this.concept, (Long)itemLimit, (Long)rowLimit);
        return result;
    }

    public static void execQueriesHop(QueryExecutionFactory qef, Collection<Node> nodes, Collection<MappedQuery<DatasetGraph>> mappedQueries, Map<Node, DatasetGraph> result) {
        for (MappedQuery<DatasetGraph> mappedQuery : mappedQueries) {
            MapService listService = MapServiceUtils.createListServiceMappedQuery((QueryExecutionFactory)qef, mappedQuery, (boolean)true);
            LookupServiceListService lookupService = LookupServiceListService.create((MapService)listService);
            lookupService = LookupServicePartition.create((LookupService)lookupService, (int)chunkSize);
            Map nodeToGraph = lookupService.fetchMap(nodes);
            DatasetGraphUtils.mergeInPlace(result, (Map)nodeToGraph);
        }
    }

    public static void processHopQuery(HopQuery hopQuery, Collection<Node> sourceNodes, Map<Node, DatasetGraph> result, QueryExecutionFactory defaultQef, Multimap<Node, Node> back) {
        HashMap<Node, DatasetGraph> map;
        QueryExecutionFactory qef = hopQuery.getQef();
        qef = qef == null ? defaultQef : qef;
        MappedQuery<DatasetGraph> mappedQuery = hopQuery.getMappedQuery();
        LookupService ls = LookupServiceUtils.createLookupService((QueryExecutionFactory)qef, mappedQuery);
        ls = LookupServicePartition.create((LookupService)ls, (int)chunkSize);
        HashMap<Node, DatasetGraph> tmpMap = ls.fetchMap(sourceNodes);
        if (back != null) {
            map = new HashMap<Node, DatasetGraph>();
            for (Map.Entry entry : tmpMap.entrySet()) {
                Node tmpNode = (Node)entry.getKey();
                DatasetGraph datasetGraph = (DatasetGraph)entry.getValue();
                Collection keys = back.get((Object)tmpNode);
                for (Node key : keys) {
                    map.put(key, datasetGraph);
                }
            }
        } else {
            map = tmpMap;
        }
        DatasetGraphUtils.mergeInPlace(result, map);
    }

    public static void processHopQueries(List<HopQuery> hopQueries, Collection<Node> sourceNodes, Map<Node, DatasetGraph> result, QueryExecutionFactory defaultQef, Multimap<Node, Node> back) {
        for (HopQuery hopQuery : hopQueries) {
            MapPaginatorHop.processHopQuery(hopQuery, sourceNodes, result, defaultQef, back);
        }
    }

    public static <T, C extends Iterable<T>> Iterable<T> flatMap(Map<T, C> map) {
        FluentIterable result = FluentIterable.from(map.values()).transformAndConcat(Functions.identity());
        return result;
    }

    public static void processHopRelations(List<HopRelation> hopRelations, Collection<Node> sourceNodes, Map<Node, DatasetGraph> result, QueryExecutionFactory defaultQef, Multimap<Node, Node> back) {
        for (HopRelation hopRelation : hopRelations) {
            MapPaginatorHop.processHopRelation(hopRelation, sourceNodes, result, defaultQef, back);
        }
    }

    public static void processHopRelation(HopRelation hopRelation, Collection<Node> sourceNodes, Map<Node, DatasetGraph> result, QueryExecutionFactory defaultQef, Multimap<Node, Node> back) {
        HashMultimap nextBack;
        QueryExecutionFactory qef = hopRelation.getQef();
        qef = qef == null ? defaultQef : qef;
        BinaryRelation relation = hopRelation.getRelation();
        LookupService ls = LookupServiceUtils.createLookupService((QueryExecutionFactory)qef, (BinaryRelation)relation);
        ls = LookupServicePartition.create((LookupService)ls, (int)chunkSize);
        Map map = ls.fetchMap(sourceNodes);
        HashMultimap tmpMm = HashMultimap.create();
        for (Map.Entry entry : map.entrySet()) {
            tmpMm.putAll(entry.getKey(), (Iterable)entry.getValue());
        }
        Multimap tmpBack = Multimaps.invertFrom((Multimap)tmpMm, (Multimap)HashMultimap.create());
        if (back != null) {
            nextBack = HashMultimap.create();
            for (Map.Entry entry : nextBack.entries()) {
                Node src = (Node)entry.getKey();
                Node tmp = (Node)entry.getValue();
                Collection tgts = back.get((Object)tmp);
                for (Node tgt : tgts) {
                    nextBack.put((Object)src, (Object)tgt);
                }
            }
        } else {
            nextBack = tmpBack;
        }
        HashSet relatedNodes = Sets.newHashSet(MapPaginatorHop.flatMap(map));
        for (Hop hop : hopRelation.getHops()) {
            MapPaginatorHop.execRec(hop, relatedNodes, result, qef, (Multimap<Node, Node>)nextBack);
        }
    }

    public static void execRec(Hop hop, Collection<Node> sourceNodes, Map<Node, DatasetGraph> result, QueryExecutionFactory defaultQef, Multimap<Node, Node> back) {
        List<HopQuery> hopQueries = hop.getHopQueries();
        List<HopRelation> hopRelations = hop.getHopRelations();
        MapPaginatorHop.processHopQueries(hopQueries, sourceNodes, result, defaultQef, back);
        MapPaginatorHop.processHopRelations(hopRelations, sourceNodes, result, defaultQef, back);
    }

    public Flowable<Map.Entry<Node, DatasetGraph>> apply(Range<Long> range) {
        return Flowable.fromIterable(this.fetchMap(range).entrySet());
    }
}

