/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.modifier;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.QueryExecutionFactoryDatasetGraph;
import org.aksw.jena_sparql_api.core.utils.ServiceUtils;
import org.aksw.jena_sparql_api.lookup.LookupService;
import org.aksw.jena_sparql_api.modifier.Modifier;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;

public class ModifierDatasetGraphEnrich
implements Modifier<DatasetGraph> {
    private LookupService<Node, DatasetGraph> lookupService;
    private Concept concept;

    public ModifierDatasetGraphEnrich(LookupService<Node, DatasetGraph> lookupService, Concept concept) {
        this.lookupService = lookupService;
        this.concept = concept;
    }

    @Override
    public void apply(DatasetGraph input) {
        QueryExecutionFactoryDatasetGraph qef = new QueryExecutionFactoryDatasetGraph(input, false);
        List nodes = ServiceUtils.fetchList((QueryExecutionFactory)qef, (Concept)this.concept);
        Map extra = this.lookupService.fetchMap((Iterable)nodes);
        for (Map.Entry entry : extra.entrySet()) {
            DatasetGraph m = (DatasetGraph)entry.getValue();
            Iterator it = m.find();
            while (it.hasNext()) {
                Quad quad = (Quad)it.next();
                input.add(quad);
            }
        }
    }
}

