/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.h2;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.aksw.jena_sparql_api.cache.core.QueryExecutionFactoryCacheEx;
import org.aksw.jena_sparql_api.cache.extra.CacheBackend;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontend;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontendImpl;
import org.aksw.jena_sparql_api.cache.staging.CacheBackendDao;
import org.aksw.jena_sparql_api.cache.staging.CacheBackendDaoPostgres;
import org.aksw.jena_sparql_api.cache.staging.CacheBackendDataSource;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.apache.commons.lang3.StringUtils;
import org.h2.jdbcx.JdbcDataSource;
import org.h2.tools.RunScript;

public class CacheUtilsH2 {
    public static CacheFrontend createCacheFrontend(String dbName, boolean dbInMemory, long cacheTTL) {
        CacheFrontend result = CacheUtilsH2.createCacheFrontend(null, dbName, dbInMemory, cacheTTL);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheFrontend createCacheFrontend(String dbDir, String dbName, boolean dbInMemory, long cacheTTL) {
        String dbType = "file";
        if (dbInMemory) {
            dbType = "mem:";
        }
        String dbd = StringUtils.isEmpty((CharSequence)dbDir) ? "" : dbDir + "/";
        ArrayList<String> options = new ArrayList<String>();
        if (!dbInMemory) {
            options.add("AUTO_SERVER=TRUE");
        }
        options.add("AUTO_RECONNECT=TRUE");
        options.add("DB_CLOSE_DELAY=-1");
        String optionsStr = options.stream().collect(Collectors.joining(";"));
        try {
            Class.forName("org.h2.Driver");
            JdbcDataSource dataSource = new JdbcDataSource();
            dataSource.setURL("jdbc:h2:" + dbType + ":" + dbd + dbName + ";" + optionsStr);
            dataSource.setUser("sa");
            dataSource.setPassword("sa");
            String schemaResourceName = "/org/aksw/jena_sparql_api/cache/cache-schema-pgsql.sql";
            InputStream in = CacheBackendDao.class.getResourceAsStream(schemaResourceName);
            if (in == null) {
                throw new RuntimeException("Failed to load resource: " + schemaResourceName);
            }
            InputStreamReader reader = new InputStreamReader(in);
            try (Connection conn = dataSource.getConnection();){
                RunScript.execute((Connection)conn, (Reader)reader);
            }
            CacheBackendDaoPostgres dao = new CacheBackendDaoPostgres(cacheTTL);
            CacheBackendDataSource cacheBackend = new CacheBackendDataSource((DataSource)dataSource, (CacheBackendDao)dao);
            return new CacheFrontendImpl((CacheBackend)cacheBackend);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create H2 CacheFrontend", e);
        }
    }

    public static QueryExecutionFactory createQueryExecutionFactory(QueryExecutionFactory decoratee, String dbName, boolean dbInMemory, long cacheTTL) {
        CacheFrontend cacheFrontend = CacheUtilsH2.createCacheFrontend(dbName, dbInMemory, cacheTTL);
        return new QueryExecutionFactoryCacheEx(decoratee, cacheFrontend);
    }
}

