/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.shape;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.MapUtils;
import org.aksw.jena_sparql_api.concept.builder.api.ConceptExpr;
import org.aksw.jena_sparql_api.concepts.BinaryRelation;
import org.aksw.jena_sparql_api.concepts.BinaryRelationImpl;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.concepts.ConceptOps;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.SparqlService;
import org.aksw.jena_sparql_api.lookup.LookupService;
import org.aksw.jena_sparql_api.lookup.LookupServiceUtils;
import org.aksw.jena_sparql_api.mapper.Agg;
import org.aksw.jena_sparql_api.mapper.AggDatasetGraph;
import org.aksw.jena_sparql_api.mapper.AggGraph;
import org.aksw.jena_sparql_api.mapper.MappedConcept;
import org.aksw.jena_sparql_api.utils.ElementUtils;
import org.aksw.jena_sparql_api.utils.ExprUtils;
import org.aksw.jena_sparql_api.utils.Generator;
import org.aksw.jena_sparql_api.utils.TripleUtils;
import org.aksw.jena_sparql_api.utils.Triples;
import org.aksw.jena_sparql_api.utils.VarGeneratorImpl;
import org.aksw.jena_sparql_api.utils.VarUtils;
import org.aksw.jena_sparql_api.utils.Vars;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.sparql.syntax.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceShape {
    private static final Logger logger = LoggerFactory.getLogger(ResourceShape.class);
    private Map<BinaryRelation, ResourceShape> out = new HashMap<BinaryRelation, ResourceShape>();
    private Map<BinaryRelation, ResourceShape> in = new HashMap<BinaryRelation, ResourceShape>();
    private ConceptExpr expr;

    public boolean isEmpty() {
        boolean result = this.out.isEmpty() && this.in.isEmpty();
        return result;
    }

    public Map<BinaryRelation, ResourceShape> getOutgoing() {
        return this.out;
    }

    public Map<BinaryRelation, ResourceShape> getIngoing() {
        return this.in;
    }

    public void extend(ResourceShape that) {
        this.out.putAll(that.out);
        this.in.putAll(that.in);
    }

    public static List<Concept> collectConcepts(ResourceShape source, boolean includeGraph) {
        ArrayList<Concept> result = new ArrayList<Concept>();
        ResourceShape.collectConcepts(result, source, includeGraph);
        return result;
    }

    public static void collectConcepts(Collection<Concept> result, ResourceShape source, boolean includeGraph) {
        VarGeneratorImpl vargen = VarGeneratorImpl.create((String)"v");
        ResourceShape.collectConcepts(result, source, (Generator<Var>)vargen, includeGraph);
    }

    public static void collectConcepts(Collection<Concept> result, ResourceShape source, Generator<Var> vargen, boolean includeGraph) {
        Concept baseConcept = new Concept((Element)null, Vars.x);
        ResourceShape.collectConcepts(result, baseConcept, source, vargen, includeGraph);
    }

    public static void collectConcepts(Collection<Concept> result, Concept baseConcept, ResourceShape source, Generator<Var> vargen, boolean includeGraph) {
        Map<BinaryRelation, ResourceShape> outgoing = source.getOutgoing();
        Map<BinaryRelation, ResourceShape> ingoing = source.getIngoing();
        ResourceShape.collectConcepts(result, baseConcept, outgoing, false, vargen, includeGraph);
        ResourceShape.collectConcepts(result, baseConcept, ingoing, true, vargen, includeGraph);
    }

    public static void collectConcepts(Collection<Concept> result, Concept baseConcept, Map<BinaryRelation, ResourceShape> map, boolean isInverse, Generator<Var> vargen, boolean includeGraph) {
        Set<BinaryRelation> raw = map.keySet();
        List<BinaryRelation> opt = ResourceShape.group(raw);
        for (BinaryRelation relation : opt) {
            Concept sc = baseConcept;
            Concept item = ResourceShape.createConcept(sc, vargen, relation, isInverse, includeGraph);
            result.add(item);
        }
        HashMultimap groups = HashMultimap.create();
        for (Map.Entry<BinaryRelation, ResourceShape> entry : map.entrySet()) {
            groups.put((Object)entry.getValue(), (Object)entry.getKey());
        }
        for (Map.Entry<Object, ResourceShape> entry : groups.asMap().entrySet()) {
            ResourceShape target = (ResourceShape)entry.getKey();
            Collection raw2 = (Collection)((Object)entry.getValue());
            List<BinaryRelation> opt2 = ResourceShape.group(raw2);
            for (BinaryRelation relation : opt2) {
                Concept sc = baseConcept;
                Concept item = ResourceShape.createConcept(sc, vargen, relation, isInverse, includeGraph);
                ResourceShape.collectConcepts(result, item, target, vargen, includeGraph);
            }
        }
    }

    public static List<BinaryRelation> group(Collection<BinaryRelation> relations) {
        ArrayList<BinaryRelation> result = new ArrayList<BinaryRelation>();
        HashSet<Node> concretePredicates = new HashSet<Node>();
        HashSet<Expr> simpleExprs = new HashSet<Expr>();
        for (BinaryRelation relation : relations) {
            Var s = relation.getSourceVar();
            Element e = relation.getElement();
            if (e instanceof ElementFilter) {
                ElementFilter filter = (ElementFilter)e;
                Expr expr = filter.getExpr();
                Map.Entry c = ExprUtils.extractConstantConstraint((Expr)expr);
                if (c != null && ((Var)c.getKey()).equals((Object)s)) {
                    Node n = ((NodeValue)c.getValue()).asNode();
                    concretePredicates.add(n);
                    continue;
                }
                simpleExprs.add(expr);
                continue;
            }
            result.add(relation);
        }
        if (!simpleExprs.isEmpty()) {
            Expr orified = ExprUtils.orifyBalanced(simpleExprs);
            BinaryRelation r = ResourceShape.asRelation(orified);
            result.add(r);
        }
        if (!concretePredicates.isEmpty()) {
            ExprList exprs = new ExprList();
            for (Node node : concretePredicates) {
                Expr expr = org.apache.jena.sparql.util.ExprUtils.nodeToExpr((Node)node);
                exprs.add(expr);
            }
            ExprVar ep = new ExprVar(Vars.p);
            E_OneOf ex = exprs.size() > 1 ? new E_OneOf((Expr)ep, exprs) : new E_Equals((Expr)ep, exprs.get(0));
            BinaryRelation r = ResourceShape.asRelation((Expr)ex);
            result.add(r);
        }
        return result;
    }

    public static BinaryRelation asRelation(Expr expr) {
        ElementFilter e = new ElementFilter(expr);
        BinaryRelationImpl result = new BinaryRelationImpl((Element)e, Vars.p, Vars.o);
        return result;
    }

    public static Element remapVars(Element element, Map<Var, Var> varMap) {
        return null;
    }

    public static Query createQuery(ResourceShape resourceShape, Concept filter, boolean includeGraph) {
        List<Concept> concepts = ResourceShape.collectConcepts(resourceShape, includeGraph);
        Query result = ResourceShape.createQuery(concepts, filter);
        return result;
    }

    @Deprecated
    public static Query createQueryConstruct(List<Concept> concepts, Concept filter) {
        Template template = new Template(BasicPattern.wrap(Collections.singletonList(Triples.spo)));
        ArrayList<Concept> tmps = new ArrayList<Concept>();
        for (Concept concept : concepts) {
            Concept tmp = ConceptOps.intersect((Concept)concept, (Concept)filter, null);
            tmps.add(tmp);
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Concept concept : tmps) {
            Element e = concept.getElement();
            elements.add(e);
        }
        Element element = ElementUtils.union(elements);
        Query result = new Query();
        result.setQueryConstructType();
        result.setConstructTemplate(template);
        result.setQueryPattern(element);
        return result;
    }

    public static MappedConcept<DatasetGraph> createMappedConcept2(ResourceShape resourceShape, Concept filter, boolean includeGraph) {
        Query query = ResourceShape.createQuery(resourceShape, filter, includeGraph);
        logger.debug("Created query from resource shape: " + query);
        MappedConcept<DatasetGraph> result = ResourceShape.createMappedConcept2(query);
        return result;
    }

    public static MappedConcept<Graph> createMappedConcept(ResourceShape resourceShape, Concept filter, boolean includeGraph) {
        Query query = ResourceShape.createQuery(resourceShape, filter, includeGraph);
        logger.debug("Created query from resource shape: " + query);
        MappedConcept<Graph> result = ResourceShape.createMappedConcept(query);
        return result;
    }

    public static MappedConcept<DatasetGraph> createMappedConcept2(Query query) {
        QuadPattern qp = new QuadPattern();
        qp.add(new Quad((Node)Vars.g, (Node)Vars.s, (Node)Vars.p, (Node)Vars.o));
        AggDatasetGraph agg = new AggDatasetGraph(qp);
        Concept concept = new Concept((Element)new ElementSubQuery(query), Vars.x);
        MappedConcept result = new MappedConcept(concept, (Agg)agg);
        return result;
    }

    public static MappedConcept<Graph> createMappedConcept(Query query) {
        BasicPattern bgp = new BasicPattern();
        bgp.add(new Triple((Node)Vars.s, (Node)Vars.p, (Node)Vars.o));
        Template template = new Template(bgp);
        AggGraph agg = new AggGraph(template, (Node)Vars.z);
        Concept concept = new Concept((Element)new ElementSubQuery(query), Vars.x);
        MappedConcept result = new MappedConcept(concept, (Agg)agg);
        return result;
    }

    public static Query createQuery(List<Concept> concepts, Concept filter) {
        Query result;
        ArrayList<Concept> tmps = new ArrayList<Concept>();
        for (Concept concept : concepts) {
            Concept tmp = ConceptOps.intersect((Concept)concept, (Concept)filter, null);
            tmps.add(tmp);
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Concept concept : tmps) {
            Element e = concept.getElement();
            Collection vs = PatternVars.vars((Element)e);
            if (!vs.contains(Vars.x)) {
                Query q = new Query();
                q.setQuerySelectType();
                q.getProject().add(Vars.x, (Expr)new ExprVar(Vars.s));
                if (vs.contains(Vars.g)) {
                    q.getProject().add(Vars.g);
                }
                q.getProject().add(Vars.s);
                q.getProject().add(Vars.p);
                q.getProject().add(Vars.o);
                q.getProject().add(Vars.z);
                q.setQueryPattern(e);
                e = new ElementSubQuery(q);
            }
            elements.add(e);
        }
        Element element = ElementUtils.union(elements);
        if (elements.size() > 1) {
            result = new Query();
            result.setQuerySelectType();
            result.getProject().add(Vars.x);
            result.getProject().add(Vars.g);
            result.getProject().add(Vars.s);
            result.getProject().add(Vars.p);
            result.getProject().add(Vars.o);
            result.getProject().add(Vars.z);
            result.setQueryPattern(element);
        } else {
            result = ((ElementSubQuery)element).getQuery();
        }
        return result;
    }

    public static Concept createConcept(Concept baseConcept, Generator<Var> vargen, BinaryRelation predicateRelation, boolean isInverse, boolean includeGraph) {
        ElementTriplesBlock e;
        Var sourceVar;
        ElementTriplesBlock e2;
        Var baseVar = baseConcept.getVar();
        Element baseElement = baseConcept.getElement();
        Triple triple = isInverse ? new Triple((Node)Vars.o, (Node)Vars.p, (Node)Vars.s) : new Triple((Node)Vars.s, (Node)Vars.p, (Node)Vars.o);
        BasicPattern bp = new BasicPattern();
        bp.add(triple);
        ElementTriplesBlock etmp = new ElementTriplesBlock(bp);
        Object object = e2 = includeGraph ? new ElementNamedGraph((Node)Vars.g, (Element)etmp) : etmp;
        if (baseElement != null) {
            HashMap<Var, Object> rename = new HashMap<Var, Object>();
            rename.put(Vars.s, vargen.next());
            rename.put(Vars.p, vargen.next());
            rename.put(Vars.z, vargen.next());
            rename.put(Vars.o, Vars.s);
            rename.put(baseVar, Vars.x);
            sourceVar = (Var)MapUtils.getOrElse(rename, (Object)baseVar, (Object)baseVar);
            Element e1 = ElementUtils.createRenamedElement((Element)baseElement, rename);
            e = ElementUtils.mergeElements((Element)e1, (Element)e2);
        } else {
            e = e2;
            sourceVar = Vars.s;
        }
        Collection eVars = PatternVars.vars((Element)e);
        Set pVars = predicateRelation.getVarsMentioned();
        Map pc = VarUtils.createDistinctVarMap((Collection)eVars, (Collection)pVars, (boolean)true, vargen);
        pc.put(predicateRelation.getSourceVar(), Vars.p);
        pc.put(predicateRelation.getTargetVar(), Vars.o);
        Element e3 = ElementUtils.createRenamedElement((Element)predicateRelation.getElement(), (Map)pc);
        Element newElement = ElementUtils.mergeElements((Element)e, (Element)e3);
        ElementBind e4 = new ElementBind(Vars.z, (Expr)NodeValue.makeBoolean((boolean)isInverse));
        newElement = ElementUtils.mergeElements((Element)newElement, (Element)e4);
        Concept result = new Concept(newElement, sourceVar);
        return result;
    }

    public static boolean contains(Collection<Expr> exprs, Triple triple, FunctionEnv functionEnv) {
        Binding binding = TripleUtils.tripleToBinding((Triple)triple);
        boolean result = false;
        for (Expr expr : exprs) {
            NodeValue nodeValue = expr.eval(binding, functionEnv);
            if (!nodeValue.equals((Object)NodeValue.TRUE)) continue;
            result = true;
            break;
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.in == null ? 0 : this.in.hashCode());
        result = 31 * result + (this.out == null ? 0 : this.out.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceShape other = (ResourceShape)obj;
        if (this.in == null ? other.in != null : !this.in.equals(other.in)) {
            return false;
        }
        return !(this.out == null ? other.out != null : !this.out.equals(other.out));
    }

    public String toString() {
        return "ResourceShape [outgoing=" + this.out + ", ingoing=" + this.in + "]";
    }

    public static Graph fetchData(SparqlService sparqlService, ResourceShape shape, Node node) {
        QueryExecutionFactory qef = sparqlService.getQueryExecutionFactory();
        Graph result = ResourceShape.fetchData(qef, shape, node);
        return result;
    }

    public static Graph fetchData(QueryExecutionFactory qef, ResourceShape shape, Node node) {
        MappedConcept<Graph> mc = ResourceShape.createMappedConcept(shape, null, false);
        LookupService ls = LookupServiceUtils.createLookupService((QueryExecutionFactory)qef, mc);
        Map map = ls.fetchMap(Collections.singleton(node));
        Graph result = map.isEmpty() ? null : (Graph)map.values().iterator().next();
        return result;
    }
}

