/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.shape.algebra.op;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.aksw.jena_sparql_api.concepts.BinaryRelation;
import org.aksw.jena_sparql_api.concepts.BinaryRelationImpl;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.concepts.ConceptOps;
import org.aksw.jena_sparql_api.concepts.ConceptUtils;
import org.aksw.jena_sparql_api.shape.algebra.op.OpAnd;
import org.aksw.jena_sparql_api.shape.algebra.op.OpAssign;
import org.aksw.jena_sparql_api.shape.algebra.op.OpConcept;
import org.aksw.jena_sparql_api.shape.algebra.op.OpEnumeration;
import org.aksw.jena_sparql_api.shape.algebra.op.OpExists;
import org.aksw.jena_sparql_api.shape.algebra.op.OpFilter;
import org.aksw.jena_sparql_api.shape.algebra.op.OpFocus;
import org.aksw.jena_sparql_api.shape.algebra.op.OpForAll;
import org.aksw.jena_sparql_api.shape.algebra.op.OpSparqlConcept;
import org.aksw.jena_sparql_api.shape.algebra.op.OpTop;
import org.aksw.jena_sparql_api.shape.algebra.op.OpType;
import org.aksw.jena_sparql_api.shape.algebra.op.OpUnion;
import org.aksw.jena_sparql_api.shape.algebra.op.OpVisitor;
import org.aksw.jena_sparql_api.shape.algebra.op.PathExVisitorSparql;
import org.aksw.jena_sparql_api.utils.ElementUtils;
import org.aksw.jena_sparql_api.utils.ExprUtils;
import org.aksw.jena_sparql_api.utils.Generator;
import org.aksw.jena_sparql_api.utils.Vars;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.vocabulary.RDF;

public class OpVisitorSparql
implements OpVisitor<Concept> {
    protected PathExVisitorSparql pathVisitor;
    protected Generator<Var> generator;

    public OpVisitorSparql(Generator<Var> generator) {
        this.generator = generator;
    }

    @Override
    public Concept visit(OpAssign op) {
        return null;
    }

    @Override
    public Concept visit(OpAnd op) {
        Concept a = op.getLeft().accept(this);
        Concept b = op.getRight().accept(this);
        Concept result = ConceptOps.intersect((Concept)a, (Concept)b, this.generator);
        return result;
    }

    @Override
    public Concept visit(OpUnion op) {
        Concept a = op.getLeft().accept(this);
        Concept b = op.getRight().accept(this);
        Concept result = ConceptOps.union((Concept)a, (Concept)b, this.generator);
        return result;
    }

    @Override
    public Concept visit(OpExists op) {
        BinaryRelation relation = op.getRole();
        Concept filler = op.getSubOp().accept(this);
        Concept result = ConceptOps.exists((BinaryRelation)relation, (Concept)filler, this.generator);
        return result;
    }

    @Override
    public Concept visit(OpForAll op) {
        BinaryRelation relation = op.getRole();
        Concept filler = op.getSubOp().accept(this);
        Concept result = ConceptOps.forAllIfRolePresent((BinaryRelation)relation, (Concept)filler, this.generator);
        return result;
    }

    @Override
    public Concept visit(OpSparqlConcept op) {
        Concept result = op.getConcept();
        return result;
    }

    @Override
    public Concept visit(OpType op) {
        Node node = op.getType();
        ElementTriplesBlock e = ElementUtils.createElement((Triple)new Triple((Node)Vars.s, RDF.type.asNode(), node));
        Concept result = new Concept((Element)e, Vars.s);
        return result;
    }

    @Override
    public Concept visit(OpTop op) {
        Concept result = Concept.TOP;
        return result;
    }

    @Override
    public Concept visit(OpConcept op) {
        Concept result = op.getConcept();
        return result;
    }

    @Override
    public Concept visit(OpFilter op) {
        Expr expr = op.getExpr();
        Concept concept = op.getSubOp().accept(this);
        Var conceptVar = concept.getVar();
        Map<Var, Var> varMap = Collections.singletonMap(Vars.lodash, conceptVar);
        Expr newExpr = ExprUtils.applyNodeTransform((Expr)expr, varMap);
        Element newElement = ElementUtils.mergeElements((Element)concept.getElement(), (Element)new ElementFilter(newExpr));
        Concept result = new Concept(newElement, conceptVar);
        return result;
    }

    @Override
    public Concept visit(OpFocus op) {
        Concept concept = op.getSubOp().accept(this);
        Path path = op.getPath();
        BinaryRelation relation = BinaryRelationImpl.create((Path)path);
        Concept result = ConceptUtils.getRelatedConcept((Concept)concept, (BinaryRelation)relation);
        return result;
    }

    @Override
    public Concept visit(OpEnumeration op) {
        List<Node> nodes = op.getNodes();
        Concept result = ConceptUtils.createConcept(nodes);
        return result;
    }
}

