/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.shape.lookup;

import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.lookup.ListService;
import org.aksw.jena_sparql_api.lookup.ListServiceMapWrapper;
import org.aksw.jena_sparql_api.lookup.LookupService;
import org.aksw.jena_sparql_api.lookup.LookupServiceListService;
import org.aksw.jena_sparql_api.lookup.MapPaginator;
import org.aksw.jena_sparql_api.lookup.MapService;
import org.aksw.jena_sparql_api.mapper.MappedConcept;
import org.aksw.jena_sparql_api.shape.ResourceShape;
import org.aksw.jena_sparql_api.shape.lookup.MapPaginatorMappedConcept;
import org.aksw.jena_sparql_api.utils.model.ResourceUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Resource;

public class MapServiceResourceShape
implements MapService<Concept, Node, Graph> {
    private QueryExecutionFactory qef;
    private ResourceShape resourceShape;
    private boolean isLeftJoin;

    public MapServiceResourceShape(QueryExecutionFactory qef, ResourceShape resourceShape, boolean isLeftJoin) {
        this.qef = qef;
        this.resourceShape = resourceShape;
        this.isLeftJoin = isLeftJoin;
    }

    public MapPaginator<Node, Graph> createPaginator(Concept filterConcept) {
        MappedConcept<Graph> mappedConcept = ResourceShape.createMappedConcept(this.resourceShape, filterConcept, false);
        MapPaginatorMappedConcept<Graph> result = new MapPaginatorMappedConcept<Graph>(this.qef, null, this.isLeftJoin, mappedConcept);
        return result;
    }

    public static MapServiceResourceShape create(QueryExecutionFactory qef, ResourceShape resourceShape, boolean isLeftJoin) {
        MapServiceResourceShape result = new MapServiceResourceShape(qef, resourceShape, isLeftJoin);
        return result;
    }

    public static ListService<Concept, Resource> createListService(QueryExecutionFactory qef, ResourceShape resourceShape, boolean isLeftJoin) {
        MapServiceResourceShape base = MapServiceResourceShape.create(qef, resourceShape, isLeftJoin);
        ListService result = ListServiceMapWrapper.create((MapService)base, ResourceUtils::asResource);
        return result;
    }

    public static LookupService<Node, Graph> createLookupService(QueryExecutionFactory qef, ResourceShape shape) {
        MapServiceResourceShape base = new MapServiceResourceShape(qef, shape, false);
        LookupServiceListService result = LookupServiceListService.create((MapService)base);
        return result;
    }
}

