/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.sparql_path.core.Context;
import org.aksw.jena_sparql_api.sparql_path.core.VocabPath;
import org.aksw.jena_sparql_api.utils.CnfUtils;
import org.aksw.jena_sparql_api.utils.ElementTreeAnalyser;
import org.aksw.jena_sparql_api.utils.ExprUtils;
import org.aksw.jena_sparql_api.utils.ReplaceConstants;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathConstraint {
    private static final Logger logger = LoggerFactory.getLogger(PathConstraint.class);
    public static final String varNs = "http://dummy.org/var/";

    public static void getPathConstraints(Concept concept) {
        Query query = concept.asQuery();
        Op op = Algebra.compile((Query)query);
        op = Algebra.toQuadForm((Op)op);
        op = ReplaceConstants.replace((Op)op);
    }

    public static List<Quad> collectQuads(Element element) {
        ArrayList<Quad> result = new ArrayList<Quad>();
        Context context = new Context();
        PathConstraint.collectQuads(element, context, result);
        return result;
    }

    public static void collectQuads(Element element, Context context, List<Quad> result) {
        if (element instanceof ElementTriplesBlock) {
            PathConstraint.collectQuads((ElementTriplesBlock)element, context, result);
        } else if (element instanceof ElementGroup) {
            PathConstraint.collectQuads((ElementGroup)element, context, result);
        } else if (element instanceof ElementPathBlock) {
            PathConstraint.collectQuads((ElementPathBlock)element, context, result);
        } else {
            logger.warn("Omitting unsupported element type: " + element.getClass() + " - " + element);
        }
    }

    public static void collectQuads(ElementTriplesBlock element, Context context, List<Quad> result) {
        Node graphNode = context.getGraphNode();
        for (Triple triple : element.getPattern().getList()) {
            Quad quad = new Quad(graphNode, triple);
            result.add(quad);
        }
    }

    public static void collectQuads(ElementGroup element, Context context, List<Quad> result) {
        for (Element e : element.getElements()) {
            PathConstraint.collectQuads(e, context, result);
        }
    }

    public static void collectQuads(ElementPathBlock element, Context context, List<Quad> result) {
        Node graphNode = context.getGraphNode();
        for (TriplePath triplePath : element.getPattern().getList()) {
            Triple triple = triplePath.asTriple();
            if (triple == null) {
                logger.warn("Omitted non-simple triple");
            }
            Quad quad = new Quad(graphNode, triple);
            result.add(quad);
        }
    }

    public static void getPathConstraints(OpProject op) {
    }

    public static void getPathConstraints(OpFilter op) {
        ExprList exprs = op.getExprs();
    }

    public static void getPathConstraints(OpQuadPattern op) {
    }

    public static Var uriToVar(Node node) {
        String tmp;
        Var result = null;
        if (node.isVariable()) {
            result = (Var)node;
        } else if (node.isURI() && (tmp = node.getURI()).startsWith(varNs)) {
            String suffix = tmp.substring(varNs.length());
            result = Var.alloc((String)suffix);
        }
        return result;
    }

    public static Node createVarUri(Var var) {
        return NodeFactory.createURI((String)(varNs + var.getName()));
    }

    public static Quad createUriVars(Quad quad) {
        Node g = quad.getGraph();
        Node s = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        if (g.isVariable()) {
            g = PathConstraint.createVarUri((Var)g);
        }
        if (s.isVariable()) {
            s = PathConstraint.createVarUri((Var)s);
        }
        if (o.isVariable()) {
            o = PathConstraint.createVarUri((Var)o);
        }
        Quad result = new Quad(g, s, p, o);
        return result;
    }

    public static Concept getPathConstraintsSimple(Concept concept) {
        ElementTriplesBlock element;
        Model model = ModelFactory.createDefaultModel();
        ElementTreeAnalyser analyser = new ElementTreeAnalyser(concept.getElement());
        List quads = analyser.getQuads();
        HashSet<Var> predVars = new HashSet<Var>();
        for (Quad quad : quads) {
            Node pred = quad.getPredicate();
            if (!pred.isVariable()) continue;
            Var v = (Var)pred;
            predVars.add(v);
        }
        List exprs = analyser.getFilterExprs();
        Expr expr = ExprUtils.andifyBalanced((Iterable)exprs);
        Expr cnf = CnfUtils.eval((Expr)expr);
        List clauses = CnfUtils.toClauses((Expr)cnf);
        ExprList predExprOrs = new ExprList();
        if (clauses != null) {
            for (ExprList clause : clauses) {
                Set clauseVars = clause.getVarsMentioned();
                if (!predVars.containsAll(clauseVars)) continue;
                Expr or = ExprUtils.orifyBalanced((Iterable)clause);
                predExprOrs.add(or);
            }
        }
        Expr predExpr = ExprUtils.andifyBalanced((Iterable)predExprOrs);
        for (Quad quad : quads) {
            Quad q = PathConstraint.createUriVars(quad);
            Statement stmt = model.asStatement(q.asTriple());
            model.add(stmt);
        }
        HashSet<Triple> result = new HashSet<Triple>();
        PathConstraint.createQueryForward(model, (Node)concept.getVar(), VocabPath.start, result);
        PathConstraint.createQueryBackward(model, (Node)concept.getVar(), VocabPath.start, result);
        BasicPattern bgp = BasicPattern.wrap(new ArrayList<Triple>(result));
        ElementTriplesBlock triplesBlock = new ElementTriplesBlock(bgp);
        if (predExpr == null) {
            element = triplesBlock;
        } else {
            Expr e = ExprUtils.andifyBalanced((Expr[])new Expr[]{predExpr});
            ElementFilter filter = new ElementFilter(e);
            ElementGroup group = new ElementGroup();
            group.addElement((Element)triplesBlock);
            group.addElement((Element)filter);
            element = group;
        }
        Concept c = new Concept((Element)element, concept.getVar());
        logger.debug("Path query is: " + c);
        return c;
    }

    public static void createQueryForward(Model model, Node node, Resource res, Set<Triple> result) {
        Node n = node.isVariable() ? PathConstraint.createVarUri((Var)node) : node;
        Resource r = model.asRDFNode(n).asResource();
        Set succs = model.listStatements(r, null, (RDFNode)null).toSet();
        for (Statement stmt : succs) {
            RDFNode oo = stmt.getObject();
            if (!oo.isURIResource()) continue;
            Property p = stmt.getPredicate();
            Resource o = oo.asResource();
            Triple t = new Triple(node, VocabPath.joinsWith.asNode(), p.asNode());
            if (result.contains(t)) continue;
            result.add(t);
            PathConstraint.createQueryForward(model, o.asNode(), p.asResource(), result);
        }
    }

    public static void createQueryBackward(Model model, Node node, Resource res, Set<Triple> result) {
        Node n = node.isVariable() ? PathConstraint.createVarUri((Var)node) : node;
        Resource r = model.asRDFNode(n).asResource();
        Set preds = model.listStatements(null, null, (RDFNode)r).toSet();
        for (Statement stmt : preds) {
            Resource s = stmt.getSubject();
            Property p = stmt.getPredicate();
            Triple t = new Triple(p.asNode(), VocabPath.joinsWith.asNode(), node);
            if (result.contains(t)) continue;
            result.add(t);
            PathConstraint.createQueryBackward(model, s.asNode(), p.asResource(), result);
        }
    }
}

