/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path2;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.aksw.jena_sparql_api.sparql_path2.NestedPath;
import org.aksw.jena_sparql_api.sparql_path2.NfaFrontier;
import org.aksw.jena_sparql_api.utils.model.TripletPath;

public class BidirectionalSearch<S, G, V, E> {
    protected NfaFrontier<S, G, V, E> fwdFrontier;
    protected NfaFrontier<S, G, V, E> bwdFrontier;
    protected Set<NestedPath<V, E>> accepted = new HashSet<NestedPath<V, E>>();
    protected Function<TripletPath<V, E>, Boolean> pathCallback;

    public static <S, V, E> Set<TripletPath<V, E>> intersect(NfaFrontier<S, V, V, E> fwd, NfaFrontier<S, V, V, E> bwd) {
        HashSet<TripletPath<V, TripletPath>> result = new HashSet<TripletPath<V, TripletPath>>();
        Set<S> fwdStates = fwd.getCurrentStates();
        Set<S> bwdStates = bwd.getCurrentStates();
        Sets.SetView commonStates = Sets.intersection(fwdStates, bwdStates);
        for (Object state : commonStates) {
            Multimap<V, NestedPath<V, E>> fwdNodeToPaths = fwd.getPaths(state);
            Multimap<V, NestedPath<V, E>> bwdNodeToPaths = bwd.getPaths(state);
            Set fwdNodes = fwdNodeToPaths.keySet();
            Set bwdNodes = bwdNodeToPaths.keySet();
            Sets.SetView commonNodes = Sets.union((Set)fwdNodes, (Set)bwdNodes);
            for (Object node : commonNodes) {
                Collection fwdPaths = fwdNodeToPaths.get(node);
                Collection bwdPaths = bwdNodeToPaths.get(node);
                for (NestedPath fwdPath : fwdPaths) {
                    for (NestedPath bwdPath : bwdPaths) {
                        TripletPath fwdPart = fwdPath.asSimplePath();
                        TripletPath bwdPart = bwdPath.asSimplePath().reverse();
                        Object start = fwdPart.getStart();
                        Object end = fwdPart.getEnd();
                        ArrayList triples = new ArrayList();
                        triples.addAll(fwdPart.getTriplets());
                        triples.addAll(bwdPart.getTriplets());
                        TripletPath path = new TripletPath(start, end, triples);
                        result.add(path);
                    }
                }
            }
        }
        return result;
    }
}

