/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.sparql_path2.NestedPath;
import org.aksw.jena_sparql_api.sparql_path2.SimplePathBfsIterator;
import org.aksw.jena_sparql_api.utils.model.Triplet;
import org.aksw.jena_sparql_api.utils.model.TripletImpl;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;

public class JGraphTUtils {
    public static <V, E> Triplet<V, E> toTriplet(Graph<V, E> graph, E edge) {
        Object s = graph.getEdgeSource(edge);
        Object t = graph.getEdgeTarget(edge);
        TripletImpl result = new TripletImpl(s, edge, t);
        return result;
    }

    public static <V, E> List<NestedPath<V, E>> getAllPaths(DirectedGraph<V, E> graph, Collection<V> starts, Collection<V> ends) {
        SimplePathBfsIterator<V, E> it = new SimplePathBfsIterator<V, E>(graph, starts, nestedPath -> ends.contains(nestedPath.getCurrent()));
        ArrayList result = new ArrayList();
        it.forEachRemaining(path -> result.addAll((Collection)path));
        return result;
    }

    public static <V, E> List<NestedPath<V, E>> getAllPaths(DirectedGraph<V, E> graph, V start, V end) {
        List<NestedPath<V, E>> result = JGraphTUtils.getAllPaths(graph, Collections.singleton(start), Collections.singleton(end));
        return result;
    }

    public static <V, E> Set<V> targets(Graph<V, E> graph, Collection<E> edges) {
        Set result = edges.stream().map(e -> graph.getEdgeTarget(e)).collect(Collectors.toSet());
        return result;
    }

    public static <V, E> Set<V> sources(Graph<V, E> graph, Collection<E> edges) {
        Set result = edges.stream().map(e -> graph.getEdgeSource(e)).collect(Collectors.toSet());
        return result;
    }

    public static <V, E> Set<V> transitiveGet(DirectedGraph<V, E> graph, Set<V> startVertices, int mode, Predicate<E> isEpsilon) {
        Set result = startVertices.stream().flatMap(v -> JGraphTUtils.transitiveGet(graph, v, mode, isEpsilon).stream()).collect(Collectors.toSet());
        return result;
    }

    public static <V, E> Set<V> transitiveGet(DirectedGraph<V, E> graph, V startVertex, int mode, Predicate<E> edgeFilter) {
        HashSet result = new HashSet();
        HashSet<V> open = new HashSet<V>(Collections.singleton(startVertex));
        while (!open.isEmpty()) {
            Iterator it = open.iterator();
            Object current = it.next();
            it.remove();
            boolean isVisited = result.contains(current);
            if (isVisited) continue;
            result.add(current);
            if (mode <= 0) {
                Collection incoming = graph.incomingEdgesOf(current).stream().filter(edgeFilter).map(e -> graph.getEdgeSource(e)).collect(Collectors.toList());
                open.addAll(incoming);
            }
            if (mode < 0) continue;
            Collection outgoing = graph.outgoingEdgesOf(current).stream().filter(edgeFilter).map(e -> graph.getEdgeTarget(e)).collect(Collectors.toList());
            open.addAll(outgoing);
        }
        return result;
    }

    public static <V, E> Set<E> resolveTransitions(DirectedGraph<V, E> graph, Predicate<E> isEpsilon, Collection<V> vertices, boolean reverse) {
        Set result = vertices.stream().flatMap(v -> JGraphTUtils.resolveTransitions(graph, isEpsilon, v, reverse).stream()).collect(Collectors.toSet());
        return result;
    }

    public static <V, E> Set<E> resolveTransitions(DirectedGraph<V, E> graph, Predicate<E> isEpsilon, V vertex, boolean reverse) {
        HashSet result = new HashSet();
        HashSet visited = new HashSet();
        HashSet open = new HashSet(reverse ? graph.incomingEdgesOf(vertex) : graph.outgoingEdgesOf(vertex));
        while (!open.isEmpty()) {
            Object target;
            Iterator it = open.iterator();
            Object edge = it.next();
            it.remove();
            boolean isVisited = visited.contains(edge);
            if (isVisited) continue;
            visited.add(edge);
            boolean isEps = isEpsilon.test(edge);
            Object object = target = reverse ? graph.getEdgeSource(edge) : graph.getEdgeTarget(edge);
            if (isEps) {
                Set nextEdges = reverse ? graph.incomingEdgesOf(vertex) : graph.outgoingEdgesOf(target);
                open.addAll(nextEdges);
                continue;
            }
            result.add(edge);
        }
        return result;
    }

    public static <V, E> void addSuperVertex(DirectedGraph<V, E> graph, V vertex, Set<V> fwdConns, Set<V> bwdConns) {
        JGraphTUtils.addSuperVertex(graph, vertex, fwdConns, false);
        JGraphTUtils.addSuperVertex(graph, vertex, fwdConns, true);
    }

    public static <V, E> void addSuperVertex(DirectedGraph<V, E> graph, V vertex, Set<V> conns, boolean reverse) {
        graph.addVertex(vertex);
        if (!reverse) {
            conns.forEach(conn -> {
                graph.addVertex(conn);
                graph.addEdge(vertex, conn);
            });
        } else {
            conns.forEach(conn -> {
                graph.addVertex(conn);
                graph.addEdge(conn, vertex);
            });
        }
    }

    public static <V, E> void addSuperVertex(DirectedGraph<V, E> graph, V vertex, V conn, boolean reverse) {
        JGraphTUtils.addSuperVertex(graph, vertex, Collections.singleton(conn), reverse);
    }
}

