/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path2;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aksw.commons.jena.jgrapht.LabeledEdge;
import org.aksw.commons.jena.jgrapht.LabeledEdgeImpl;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.sparql_path2.JGraphTUtils;
import org.aksw.jena_sparql_api.sparql_path2.NestedPath;
import org.aksw.jena_sparql_api.sparql_path2.Nfa;
import org.aksw.jena_sparql_api.sparql_path2.NfaExecutionUtils;
import org.aksw.jena_sparql_api.sparql_path2.PredicateClass;
import org.aksw.jena_sparql_api.sparql_path2.ValueSet;
import org.aksw.jena_sparql_api.utils.model.Directed;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.rdf.model.Model;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedGraphUnion;

public class JoinSummaryUtils {
    public static Model createPredicateJoinSummary(QueryExecutionFactory qef) {
        String queryStr = "PREFIX r: <http://example.org/resource/>PREFIX o: <http://example.org/ontology/>CONSTRUCT {\n  ?s\n    a o:PredicateJoinSummary ;\n    o:sourcePredicate ?x ;\n    o:targetPredicate ?y ;\n    o:freqTotal ?ct ;\n    o:freqSource ?ca ;\n    o:freqIntermediary ?cb ;\n    o:freqTarget ?cc\n}\n{\n  { SELECT ?x ?y (Count(*) As ?ct) (Count(Distinct ?a) As ?ca) (Count(Distinct ?b) As ?cb) (Count(Distinct ?c) As ?cc) {\n    ?a ?x ?b .\n    ?b ?y ?c .\n  } GROUP BY ?x ?y }\n  BIND(r:training_dataset As ?d)\n  BIND(uri(concat(str(r:join), '-', encode_for_uri(?d), '-', md5(concat(str(?x), str(?y))))) As ?s)\n}\n";
        QueryExecution qe = qef.createQueryExecution(queryStr);
        Model result = qe.execConstruct();
        return result;
    }

    public static Model createPredicateSummary(QueryExecutionFactory qef) {
        String queryStr = "PREFIX r: <http://example.org/resource/>\nPREFIX o: <http://example.org/ontology/>\nCONSTRUCT {\n  ?s\n    a o:PredicateSummary ;\n    o:predicate ?x ;\n    o:freqTotal ?ct ;\n    o:freqSource ?ca ;\n    o:freqTarget ?cb\n}\n{\n  { SELECT ?x (Count(*) As ?ct) (Count(Distinct ?a) As ?ca) (Count(Distinct ?b) As ?cb) {\n    ?a ?x ?b .\n  } GROUP BY ?x }\n  BIND(r:training_dataset As ?d)\n  BIND(uri(concat(str(r:predicate), '-', encode_for_uri(?d), '-', encode_for_uri(?x))) As ?s)\n}\n";
        QueryExecution qe = qef.createQueryExecution(queryStr);
        Model result = qe.execConstruct();
        return result;
    }

    public static List<NestedPath<Node, DefaultEdge>> findJoinSummaryPaths(Nfa<Integer, LabeledEdge<Integer, PredicateClass>> nfa, Set<Integer> states, DirectedGraph<Node, DefaultEdge> joinGraph, Node augStart, Node augEnd, Long k) {
        List<NestedPath<Node, DefaultEdge>> reachabilityPaths = NfaExecutionUtils.findPathsInJoinSummary(nfa, LabeledEdgeImpl::isEpsilon, states, joinGraph, augStart, 1L, (trans, node) -> {
            HashSet r = new HashSet();
            PredicateClass pc = (PredicateClass)((Object)((Object)trans.getLabel()));
            for (int i = 0; i < 2; ++i) {
                boolean transReverse = i == 1;
                ValueSet preds = (ValueSet)pc.get(i);
                Set edges = transReverse ? joinGraph.incomingEdgesOf(node) : joinGraph.outgoingEdgesOf(node);
                edges.stream().map(edge -> transReverse ? (Node)joinGraph.getEdgeSource(edge) : (Node)joinGraph.getEdgeTarget(edge)).filter(p -> preds.contains(p)).map(p -> new Directed(p, transReverse)).forEach(r::add);
            }
            return r;
        }, (trans, diPred) -> {
            Node pred = diPred == null ? null : (Node)diPred.getValue();
            PredicateClass pc = (PredicateClass)((Object)((Object)trans.getLabel()));
            HashSet<Directed> r = new HashSet<Directed>();
            boolean predReverse = diPred.isReverse();
            for (int i = 0; i < 2; ++i) {
                boolean transReverse = i == 1;
                ValueSet transPolPreds = (ValueSet)pc.get(i);
                Set transPreds = transPolPreds.getValues();
                if (predReverse == transReverse) {
                    if (pred.equals((Object)Node.ANY)) {
                        if (transPolPreds.isPositive()) {
                            transPreds.stream().map(p -> new Directed(p, transReverse)).forEach(r::add);
                            continue;
                        }
                        r.add(new Directed((Object)Node.ANY, transReverse));
                        continue;
                    }
                    Set edges = transReverse ? joinGraph.incomingEdgesOf((Object)pred) : joinGraph.outgoingEdgesOf((Object)pred);
                    edges.stream().map(edge -> transReverse ? (Node)joinGraph.getEdgeSource(edge) : (Node)joinGraph.getEdgeTarget(edge)).filter(p -> transPolPreds.contains(p)).map(p -> new Directed(p, transReverse)).forEach(r::add);
                    continue;
                }
                if (transPolPreds.isEmpty()) continue;
                r.add(new Directed((Object)Node.ANY, transReverse));
            }
            return r;
        }, nestedPath -> {
            Node current = (Node)nestedPath.getCurrent();
            boolean r = current.equals((Object)Node.ANY) || ((Node)nestedPath.getCurrent()).equals((Object)augEnd);
            return r;
        });
        reachabilityPaths.forEach(o -> System.out.println("REACHPATH: " + o.asSimplePath()));
        return reachabilityPaths;
    }

    public static boolean existsJoinSummaryPath(Nfa<Integer, LabeledEdge<Integer, PredicateClass>> nfa, Set<Integer> states, DirectedGraph<Node, DefaultEdge> joinGraph, Node augStart, Node augEnd) {
        List<NestedPath<Node, DefaultEdge>> paths = JoinSummaryUtils.findJoinSummaryPaths(nfa, states, joinGraph, augStart, augEnd, 1L);
        boolean result = !paths.isEmpty();
        return result;
    }

    public static boolean existsReachability(Nfa<Integer, LabeledEdge<Integer, PredicateClass>> nfa, Set<Integer> states, DirectedGraph<Node, DefaultEdge> endAugJoinGraph, Node augEnd, Node predicate, boolean reverse) {
        DefaultDirectedGraph augJoinGraph = new DefaultDirectedGraph(DefaultEdge.class);
        Node augStart = NodeFactory.createURI((String)"http://start.org");
        JGraphTUtils.addSuperVertex(augJoinGraph, augStart, predicate, reverse);
        DirectedGraphUnion joinGraph = new DirectedGraphUnion((DirectedGraph)augJoinGraph, endAugJoinGraph);
        boolean result = JoinSummaryUtils.existsJoinSummaryPath(nfa, states, (DirectedGraph<Node, DefaultEdge>)joinGraph, augStart, augEnd);
        return result;
    }
}

