/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path2;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.aksw.commons.jena.jgrapht.LabeledEdge;
import org.aksw.jena_sparql_api.sparql_path2.JGraphTUtils;
import org.aksw.jena_sparql_api.sparql_path2.NestedPath;
import org.aksw.jena_sparql_api.sparql_path2.Nfa;
import org.aksw.jena_sparql_api.sparql_path2.NfaFrontier;
import org.aksw.jena_sparql_api.sparql_path2.ParentLink;
import org.aksw.jena_sparql_api.sparql_path2.ValueSet;
import org.aksw.jena_sparql_api.utils.Pair;
import org.aksw.jena_sparql_api.utils.model.Directed;
import org.aksw.jena_sparql_api.utils.model.Triplet;
import org.aksw.jena_sparql_api.utils.model.TripletImpl;
import org.jgrapht.DirectedGraph;

public class NfaExecutionUtils {
    public static <S, T, G, V, E> boolean collectPaths(Nfa<S, T> nfa, NfaFrontier<S, G, V, E> frontier, Predicate<T> isEpsilon, Function<NestedPath<V, E>, Boolean> pathCallback) {
        boolean isFinished = false;
        Set<S> currentStates = frontier.getCurrentStates();
        for (S state : currentStates) {
            boolean isFinal = NfaExecutionUtils.isFinalState(nfa, state, isEpsilon);
            if (isFinal) {
                NestedPath path;
                Multimap<G, NestedPath<V, E>> ps = frontier.getPaths(state);
                Iterator iterator = ps.values().iterator();
                while (iterator.hasNext() && !(isFinished = pathCallback.apply(path = (NestedPath)iterator.next()).booleanValue())) {
                }
            }
            if (!isFinished) continue;
            break;
        }
        return isFinished;
    }

    public static <S, D, T extends LabeledEdge<S, ? extends Directed<? extends ValueSet<D>>>> Pair<ValueSet<D>> extractNextPropertyClasses(DirectedGraph<S, T> nfaGraph, Predicate<T> isEpsilon, Set<S> states, boolean reverse) {
        Set<LabeledEdge> transitions = JGraphTUtils.resolveTransitions(nfaGraph, isEpsilon, states, false);
        ValueSet fwd = ValueSet.createEmpty();
        ValueSet bwd = ValueSet.createEmpty();
        for (LabeledEdge transition : transitions) {
            Directed label = (Directed)transition.getLabel();
            boolean isReverse = label.isReverse();
            isReverse = reverse ? !isReverse : isReverse;
            ValueSet valueSet = (ValueSet)label.getValue();
            if (isReverse) {
                bwd = bwd.union(valueSet);
                continue;
            }
            fwd = fwd.union(valueSet);
        }
        Pair result = new Pair(fwd, bwd);
        return result;
    }

    public static <S, T, G, V, E> NfaFrontier<S, G, V, E> advanceFrontier(NfaFrontier<S, G, V, E> frontier, DirectedGraph<S, T> nfaGraph, Predicate<T> isEpsilon, BiFunction<T, Multimap<G, NestedPath<V, E>>, Map<V, Set<Triplet<V, E>>>> getMatchingTriplets, Function<NestedPath<V, E>, G> pathGrouper, Predicate<NestedPath<V, E>> earlyPathReject) {
        NfaFrontier result = new NfaFrontier();
        Set<S> currentStates = frontier.getCurrentStates();
        for (S state : currentStates) {
            Multimap<G, NestedPath<V, E>> ps = frontier.getPaths(state);
            Set<T> transitions = JGraphTUtils.resolveTransitions(nfaGraph, isEpsilon, state, false);
            for (T trans : transitions) {
                Map vToTriplets = getMatchingTriplets.apply(trans, ps);
                Collection allPaths = ps.values();
                for (NestedPath parentPath : allPaths) {
                    Object node = parentPath.getCurrent();
                    Set triplets = vToTriplets.getOrDefault(node, Collections.emptySet());
                    for (Triplet t : triplets) {
                        boolean reject;
                        Object o;
                        Directed p0;
                        Object p = t.getPredicate();
                        if (t.getSubject().equals(node)) {
                            p0 = new Directed(p, false);
                            o = t.getObject();
                        } else if (t.getObject().equals(node)) {
                            p0 = new Directed(p, true);
                            o = t.getSubject();
                        } else {
                            throw new RuntimeException("Should not happen");
                        }
                        NestedPath next = new NestedPath(new ParentLink(parentPath, p0), o);
                        G groupKey = pathGrouper.apply(next);
                        if (!next.isCycleFree() || (reject = earlyPathReject.test(next))) continue;
                        Object targetState = nfaGraph.getEdgeTarget(trans);
                        result.add(targetState, groupKey, next);
                    }
                }
            }
        }
        return result;
    }

    public static <S, T> boolean isFinalState(Nfa<S, T> nfa, S state, Predicate<T> isEpsilon) {
        DirectedGraph<S, T> graph = nfa.getGraph();
        Set endStates = nfa.getEndStates();
        Set<S> reachableStates = JGraphTUtils.transitiveGet(graph, state, 1, x -> isEpsilon.test(x));
        boolean result = reachableStates.stream().anyMatch(s -> endStates.contains(s));
        return result;
    }

    public static <S, T> boolean isStartState(Nfa<S, T> nfa, S state, Predicate<T> isEpsilon) {
        DirectedGraph<S, T> graph = nfa.getGraph();
        Set startStates = nfa.getStartStates();
        Set<S> reachableStates = JGraphTUtils.transitiveGet(graph, state, -1, x -> isEpsilon.test(x));
        boolean result = reachableStates.stream().anyMatch(s -> startStates.contains(s));
        return result;
    }

    public static <S, T, P, Q> boolean isTargetReachable(Nfa<S, T> nfa, Predicate<T> isEpsilon, Set<S> states, BiPredicate<Directed<T>, Q> matcher, DirectedGraph<P, Q> joinGraph, Directed<P> diPredicate, Pair<Set<P>> targetPreds) {
        return false;
    }

    public static <S, T, P, Q> List<NestedPath<P, Q>> findPathsInJoinSummary(Nfa<S, T> nfa, Predicate<T> isEpsilon, Set<S> states, DirectedGraph<P, Q> joinGraph, P startVertex, Long k, BiFunction<T, P, Set<Directed<P>>> initPred, BiFunction<T, Directed<P>, Set<Directed<P>>> transAndNodesToTriplets, Function<NestedPath<P, Q>, Boolean> pathCallback) {
        Function<NestedPath, Directed> pathGrouper = nestedPath -> nestedPath.getParentLink().map(pl -> new Directed(nestedPath.getCurrent(), pl.getDiProperty().isReverse())).orElse(null);
        ArrayList result = new ArrayList();
        NfaExecutionUtils.executeNfa(nfa, states, isEpsilon, Collections.singleton(startVertex), pathGrouper, (trans, diPredToPaths) -> {
            HashMap r = new HashMap();
            for (Map.Entry entry : diPredToPaths.asMap().entrySet()) {
                Directed diPred = (Directed)entry.getKey();
                if (diPred == null) {
                    Collection paths = (Collection)entry.getValue();
                    paths.stream().forEach(path -> {
                        Object n = path.getCurrent();
                        Set succ = (Set)initPred.apply(trans, path.getCurrent());
                        Set triplets = succ.stream().map(dp -> TripletImpl.create((Object)n, null, (Object)dp.getValue(), (boolean)dp.isReverse())).collect(Collectors.toSet());
                        r.put(n, triplets);
                    });
                    continue;
                }
                Object pred = diPred.getValue();
                Set nextDiPreds = (Set)transAndNodesToTriplets.apply(trans, diPred);
                Set triplets = nextDiPreds.stream().map(dp -> TripletImpl.create((Object)pred, null, (Object)dp.getValue(), (boolean)dp.isReverse())).collect(Collectors.toSet());
                r.put(pred, triplets);
            }
            return r;
        }, nestedPath -> {
            boolean accept = (Boolean)pathCallback.apply((NestedPath)nestedPath);
            if (accept) {
                result.add((NestedPath)nestedPath);
            }
            boolean abort = k != null && (long)result.size() >= k;
            return abort;
        });
        return result;
    }

    public static <S, T, G, V, E> void executeNfa(Nfa<S, T> nfa, Set<S> startStates, Predicate<T> isEpsilon, Set<V> startVertices, Function<NestedPath<V, E>, G> pathGrouper, BiFunction<T, Multimap<G, NestedPath<V, E>>, Map<V, Set<Triplet<V, E>>>> getMatchingTriplets, Function<NestedPath<V, E>, Boolean> pathCallback) {
        boolean abort;
        NfaFrontier frontier = new NfaFrontier();
        NfaFrontier.addAll(frontier, startStates, pathGrouper, startVertices);
        while (!frontier.isEmpty() && !(abort = NfaExecutionUtils.collectPaths(nfa, frontier, isEpsilon, pathCallback))) {
            DirectedGraph<S, T> nfaGraph = nfa.getGraph();
            NfaFrontier nextFrontier = NfaExecutionUtils.advanceFrontier(frontier, nfaGraph, isEpsilon, getMatchingTriplets, pathGrouper, x -> false);
            frontier = nextFrontier;
        }
    }
}

