/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path2;

import java.util.Set;
import org.aksw.jena_sparql_api.sparql_path2.Nfa;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.EdgeReversedGraph;

public class NfaImpl<V, E>
implements Nfa<V, E> {
    protected DirectedGraph<V, E> graph;
    protected Set<V> startStates;
    protected Set<V> endStates;

    public NfaImpl(DirectedGraph<V, E> graph, Set<V> startStates, Set<V> endStates) {
        this.graph = graph;
        this.startStates = startStates;
        this.endStates = endStates;
    }

    @Override
    public DirectedGraph<V, E> getGraph() {
        return this.graph;
    }

    @Override
    public Set<V> getStartStates() {
        return this.startStates;
    }

    @Override
    public Set<V> getEndStates() {
        return this.endStates;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.endStates == null ? 0 : this.endStates.hashCode());
        result = 31 * result + (this.graph == null ? 0 : this.graph.hashCode());
        result = 31 * result + (this.startStates == null ? 0 : this.startStates.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NfaImpl other = (NfaImpl)obj;
        if (this.endStates == null ? other.endStates != null : !this.endStates.equals(other.endStates)) {
            return false;
        }
        if (this.graph == null ? other.graph != null : !this.graph.equals(other.graph)) {
            return false;
        }
        return !(this.startStates == null ? other.startStates != null : !this.startStates.equals(other.startStates));
    }

    public String toString() {
        return "NfaImpl [graph=" + this.graph + ", startStates=" + this.startStates + ", endStates=" + this.endStates + "]";
    }

    public static <V, E> Nfa<V, E> reverse(Nfa<V, E> nfa) {
        EdgeReversedGraph g = new EdgeReversedGraph(nfa.getGraph());
        NfaImpl<V, E> result = new NfaImpl<V, E>(g, nfa.getEndStates(), nfa.getStartStates());
        return result;
    }
}

