/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path2;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.aksw.jena_sparql_api.sparql_path2.EdgeLabelAccessor;
import org.aksw.jena_sparql_api.sparql_path2.HalfEdge;
import org.aksw.jena_sparql_api.sparql_path2.PartialNfa;
import org.jgrapht.DirectedGraph;
import org.jgrapht.VertexFactory;

public class NfaOps {
    public static <V, E, T> PartialNfa<V, T> concatenate(DirectedGraph<V, E> graph, PartialNfa<V, T> a, PartialNfa<V, T> b, EdgeLabelAccessor<E, T> edgeLabelAccessor) {
        V target = b.getStartVertex();
        for (HalfEdge<V, T> looseEnd : a.getLooseEnds()) {
            V start = looseEnd.getStartVertex();
            T edgeLabel = looseEnd.getEdgeLabel();
            Object edge = graph.addEdge(start, target);
            edgeLabelAccessor.setLabel(edge, edgeLabel);
        }
        PartialNfa<V, T> result = PartialNfa.create(a.getStartVertex(), b.getLooseEnds());
        return result;
    }

    public static <V, E, T> PartialNfa<V, T> alternate(DirectedGraph<V, E> graph, VertexFactory<V> vertexFactory, PartialNfa<V, T> a, PartialNfa<V, T> b) {
        Object newStartVertex = vertexFactory.createVertex();
        graph.addVertex(newStartVertex);
        graph.addEdge(newStartVertex, a.getStartVertex());
        graph.addEdge(newStartVertex, b.getStartVertex());
        ImmutableList newLooseEnds = FluentIterable.from(a.getLooseEnds()).append(b.getLooseEnds()).toList();
        PartialNfa result = PartialNfa.create(newStartVertex, newLooseEnds);
        return result;
    }

    public static <V, E, T> PartialNfa<V, T> zeroOrOne(DirectedGraph<V, E> graph, VertexFactory<V> vertexFactory, PartialNfa<V, T> a) {
        Object newStartVertex = vertexFactory.createVertex();
        graph.addVertex(newStartVertex);
        V oldStartVertex = a.getStartVertex();
        graph.addEdge(newStartVertex, oldStartVertex);
        ImmutableList newLooseEnds = FluentIterable.from(a.getLooseEnds()).append(Collections.singletonList(new HalfEdge<Object, Object>(newStartVertex, null))).toList();
        PartialNfa result = PartialNfa.create(newStartVertex, newLooseEnds);
        return result;
    }

    public static <V, E, T> PartialNfa<V, T> zeroOrMore(DirectedGraph<V, E> graph, VertexFactory<V> vertexFactory, PartialNfa<V, T> a, EdgeLabelAccessor<E, T> edgeLabelAccessor) {
        Object newStartVertex = vertexFactory.createVertex();
        graph.addVertex(newStartVertex);
        V oldStartVertex = a.getStartVertex();
        graph.addEdge(newStartVertex, oldStartVertex);
        for (HalfEdge<V, T> looseEnd : a.getLooseEnds()) {
            Object edge = graph.addEdge(looseEnd.getStartVertex(), newStartVertex);
            edgeLabelAccessor.setLabel(edge, looseEnd.getEdgeLabel());
        }
        List newLooseEnds = Collections.singletonList(new HalfEdge<Object, Object>(newStartVertex, null));
        PartialNfa result = PartialNfa.create(newStartVertex, newLooseEnds);
        return result;
    }

    public static <V, E, T> PartialNfa<V, T> oneOrMore(DirectedGraph<V, E> graph, VertexFactory<V> vertexFactory, PartialNfa<V, T> a, EdgeLabelAccessor<E, T> edgeLabelAccessor) {
        Object tmpVertex = vertexFactory.createVertex();
        graph.addVertex(tmpVertex);
        for (HalfEdge<V, T> looseEnd : a.getLooseEnds()) {
            Object edge = graph.addEdge(looseEnd.getStartVertex(), tmpVertex);
            edgeLabelAccessor.setLabel(edge, looseEnd.getEdgeLabel());
        }
        V oldStartVertex = a.getStartVertex();
        graph.addEdge(tmpVertex, oldStartVertex);
        List newLooseEnds = Collections.singletonList(new HalfEdge<Object, Object>(tmpVertex, null));
        PartialNfa result = PartialNfa.create(oldStartVertex, newLooseEnds);
        return result;
    }
}

