/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path2;

import java.util.Set;
import java.util.function.Function;
import org.aksw.commons.jena.jgrapht.LabeledEdge;
import org.aksw.commons.jena.jgrapht.LabeledEdgeImpl;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.lookup.LookupService;
import org.aksw.jena_sparql_api.lookup.LookupServiceFilterKey;
import org.aksw.jena_sparql_api.lookup.LookupServiceListService;
import org.aksw.jena_sparql_api.lookup.MapService;
import org.aksw.jena_sparql_api.lookup.MapServiceUtils;
import org.aksw.jena_sparql_api.mapper.MappedConcept;
import org.aksw.jena_sparql_api.shape.ResourceShape;
import org.aksw.jena_sparql_api.shape.ResourceShapeBuilder;
import org.aksw.jena_sparql_api.sparql_path2.NestedPath;
import org.aksw.jena_sparql_api.sparql_path2.Nfa;
import org.aksw.jena_sparql_api.sparql_path2.NfaExecutionUtils;
import org.aksw.jena_sparql_api.sparql_path2.NfaFrontier;
import org.aksw.jena_sparql_api.sparql_path2.PathCompiler;
import org.aksw.jena_sparql_api.sparql_path2.PathVisitorResourceShapeBuilder;
import org.aksw.jena_sparql_api.sparql_path2.PredicateClass;
import org.aksw.jena_sparql_api.sparql_path2.ValueSet;
import org.aksw.jena_sparql_api.utils.Pair;
import org.aksw.jena_sparql_api.utils.model.Triplet;
import org.aksw.jena_sparql_api.utils.model.TripletImpl;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.path.Path;

public class PathExecutionUtils {
    public static <S, T> LookupService<Node, Set<Triplet<Node, Node>>> createLookupService(QueryExecutionFactory qef, Pair<ValueSet<Node>> predicateClass) {
        ResourceShapeBuilder rsb = new ResourceShapeBuilder();
        PathVisitorResourceShapeBuilder.apply(rsb, predicateClass, false);
        MappedConcept<Graph> mc = ResourceShape.createMappedConcept(rsb.getResourceShape(), null, false);
        MapService ls = MapServiceUtils.createListServiceAcc((QueryExecutionFactory)qef, mc, (boolean)false);
        LookupServiceListService lsls = LookupServiceListService.create((MapService)ls);
        lsls = new LookupServiceFilterKey((LookupService)lsls, k -> k.isURI());
        LookupService s = lsls.mapValues((k, e) -> {
            Set<Triplet<Node, Node>> r = PathExecutionUtils.graphToTriplets(e);
            return r;
        });
        return s;
    }

    public static Set<Triplet<Node, Node>> graphToTriplets(Graph graph) {
        Set result = graph.find(Node.ANY, Node.ANY, Node.ANY).mapWith(t -> new TripletImpl((Object)t.getSubject(), (Object)t.getPredicate(), (Object)t.getObject())).toSet();
        return result;
    }

    public static void executePath(Path path, Node startNode, Node targetNode, QueryExecutionFactory qef, Function<NestedPath<Node, Node>, Boolean> pathCallback) {
        boolean abort;
        Nfa<Integer, LabeledEdge<Integer, PredicateClass>> nfa = PathCompiler.compileToNfa(path);
        System.out.println("NFA");
        System.out.println(nfa);
        for (LabeledEdge edge : nfa.getGraph().edgeSet()) {
            System.out.println(edge);
        }
        NfaFrontier frontier = new NfaFrontier();
        Function<NestedPath, Node> nodeGrouper = nestedPath -> (Node)nestedPath.getCurrent();
        NfaFrontier.addAll(frontier, nfa.getStartStates(), nodeGrouper, startNode);
        if (!frontier.isEmpty() && !(abort = NfaExecutionUtils.collectPaths(nfa, frontier, LabeledEdgeImpl::isEpsilon, pathCallback))) {
            throw new RuntimeException("Adjust the code");
        }
    }
}

