/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path2;

import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import org.aksw.jena_sparql_api.sparql_path2.EdgeLabelAccessor;
import org.aksw.jena_sparql_api.sparql_path2.HalfEdge;
import org.aksw.jena_sparql_api.sparql_path2.Nfa;
import org.aksw.jena_sparql_api.sparql_path2.NfaImpl;
import org.aksw.jena_sparql_api.sparql_path2.PartialNfa;
import org.aksw.jena_sparql_api.sparql_path2.PathVisitorNfaCompilerBase;
import org.apache.jena.sparql.path.P_Inverse;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_NegPropSet;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.Path;
import org.jgrapht.DirectedGraph;
import org.jgrapht.VertexFactory;

public class PathVisitorNfaCompilerImpl<V, E, D>
extends PathVisitorNfaCompilerBase<V, E, D> {
    protected Function<Path, D> primitivePathMapper;

    public PathVisitorNfaCompilerImpl(DirectedGraph<V, E> graph, VertexFactory<V> vertexFactory, EdgeLabelAccessor<E, D> edgeLabelAccessor, Function<Path, D> primitivePathMapper) {
        super(graph, vertexFactory, edgeLabelAccessor);
        this.primitivePathMapper = primitivePathMapper;
    }

    public void processPrimitivePath(Path path) {
        D edgeLabel = this.primitivePathMapper.apply(path);
        Object s = this.vertexFactory.createVertex();
        this.graph.addVertex(s);
        PartialNfa partialNfa = PartialNfa.create(s, Collections.singletonList(new HalfEdge<Object, D>(s, edgeLabel)));
        this.stack.push(partialNfa);
    }

    public void visit(P_Link path) {
        this.processPrimitivePath((Path)path);
    }

    public void visit(P_ReverseLink path) {
        this.processPrimitivePath((Path)path);
    }

    public void visit(P_NegPropSet path) {
        this.processPrimitivePath((Path)path);
    }

    public void visit(P_Inverse path) {
        this.processPrimitivePath((Path)path);
    }

    public Nfa<V, E> complete() {
        PartialNfa partialNfa = this.peek();
        Object finalVertex = this.vertexFactory.createVertex();
        this.graph.addVertex(finalVertex);
        for (HalfEdge looseEnd : partialNfa.getLooseEnds()) {
            Object v = looseEnd.getStartVertex();
            Object label = looseEnd.getEdgeLabel();
            Object edge = this.graph.addEdge(v, finalVertex);
            this.edgeLabelAccessor.setLabel(edge, label);
        }
        Set startStates = Collections.singleton(partialNfa.getStartVertex());
        Set<Object> finalStates = Collections.singleton(finalVertex);
        NfaImpl result = new NfaImpl(this.graph, startStates, finalStates);
        return result;
    }
}

