/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path2;

import java.util.Set;
import org.aksw.jena_sparql_api.shape.ResourceShapeBuilder;
import org.aksw.jena_sparql_api.sparql_path2.ValueSet;
import org.aksw.jena_sparql_api.utils.ExprListUtils;
import org.aksw.jena_sparql_api.utils.Pair;
import org.aksw.jena_sparql_api.utils.Vars;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.E_NotOneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_NegPropSet;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.PathVisitorBase;

public class PathVisitorResourceShapeBuilder
extends PathVisitorBase {
    protected ResourceShapeBuilder rsb;
    protected boolean reverse;

    public PathVisitorResourceShapeBuilder() {
        this(new ResourceShapeBuilder(), false);
    }

    public PathVisitorResourceShapeBuilder(boolean reverse) {
        this(new ResourceShapeBuilder(), reverse);
    }

    public PathVisitorResourceShapeBuilder(ResourceShapeBuilder rsb, boolean reverse) {
        this.rsb = rsb;
        this.reverse = reverse;
    }

    public ResourceShapeBuilder getResourceShapeBuilder() {
        return this.rsb;
    }

    public void visit(P_ReverseLink path) {
        this.rsb.nav(path.getNode(), !this.reverse);
    }

    public void visit(P_Link path) {
        this.rsb.nav(path.getNode(), this.reverse);
    }

    public void visit(P_NegPropSet path) {
        E_NotOneOf expr;
        if (!path.getFwdNodes().isEmpty()) {
            expr = new E_NotOneOf((Expr)new ExprVar(Vars.p), ExprListUtils.nodesToExprs((Iterable)path.getFwdNodes()));
            this.rsb.nav((Expr)expr, this.reverse);
        }
        if (!path.getBwdNodes().isEmpty()) {
            expr = new E_NotOneOf((Expr)new ExprVar(Vars.p), ExprListUtils.nodesToExprs((Iterable)path.getBwdNodes()));
            this.rsb.nav((Expr)expr, !this.reverse);
        }
    }

    public static void apply(ResourceShapeBuilder rsb, ValueSet<Node> valueSet, boolean reverse) {
        boolean isPositive = valueSet.isPositive();
        Set<Node> nodes = valueSet.getValues();
        if (isPositive) {
            for (Node value : nodes) {
                rsb.nav(value, reverse);
            }
        } else if (!nodes.isEmpty()) {
            E_NotOneOf expr = new E_NotOneOf((Expr)new ExprVar(Vars.p), ExprListUtils.nodesToExprs(nodes));
            rsb.nav((Expr)expr, !reverse);
        }
    }

    public static void apply(ResourceShapeBuilder rsb, Pair<ValueSet<Node>> predicateClass, boolean reverse) {
        PathVisitorResourceShapeBuilder.apply(rsb, (ValueSet)predicateClass.getKey(), !reverse);
        PathVisitorResourceShapeBuilder.apply(rsb, (ValueSet)predicateClass.getValue(), reverse);
    }
}

