/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.SparqlService;
import org.aksw.jena_sparql_api.sparql_path2.SparqlKShortestPathFinder;
import org.aksw.jena_sparql_api.sparql_path2.SparqlKShortestPathFinderMem;
import org.aksw.jena_sparql_api.utils.ListUtils;
import org.aksw.jena_sparql_api.utils.model.Directed;
import org.aksw.jena_sparql_api.utils.model.TripletPath;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sdb.store.Feature;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathParser;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropFuncArgType;
import org.apache.jena.sparql.pfunction.PropertyFunctionEval;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFunctionKShortestPaths
extends PropertyFunctionEval {
    private static final Logger logger = LoggerFactory.getLogger(PropertyFunctionKShortestPaths.class);
    public static final String DEFAULT_IRI = "http://jsa.aksw.org/fn/kShortestPaths";
    public static final Symbol PROLOGUE = Feature.Name.create((String)"prologue");
    public static final Symbol SPARQL_SERVICE = Feature.Name.create((String)"sparqlService");
    protected Function<SparqlService, SparqlKShortestPathFinder> serviceToPathFinder;

    public PropertyFunctionKShortestPaths(Function<SparqlService, SparqlKShortestPathFinder> serviceToPathFinder) {
        super(PropFuncArgType.PF_ARG_SINGLE, PropFuncArgType.PF_ARG_EITHER);
        this.serviceToPathFinder = serviceToPathFinder;
    }

    public QueryIterator execEvaluated(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        Object o;
        Context ctx = execCxt.getContext();
        System.out.println("CONTEXT" + ctx);
        Prologue prologue = (Prologue)ctx.get(PROLOGUE);
        SparqlService ss = (SparqlService)ctx.get(SPARQL_SERVICE);
        Objects.requireNonNull(ss);
        QueryExecutionFactory qef = ss.getQueryExecutionFactory();
        Objects.requireNonNull(qef);
        List argList = argObject.getArgList();
        Node pathNode = (Node)ListUtils.safeGet((List)argList, (int)0);
        Node outNode = (Node)ListUtils.safeGet((List)argList, (int)1);
        Node targetNode = (Node)ListUtils.safeGet((List)argList, (int)2);
        Node kNode = (Node)ListUtils.safeGet((List)argList, (int)3);
        if (targetNode != null) {
            if (targetNode.isVariable()) {
                targetNode = binding.get((Var)targetNode);
            }
            if (targetNode != null && targetNode.isBlank()) {
                targetNode = null;
            }
        }
        Long tmpK = null;
        if (kNode != null && kNode.isLiteral() && (o = kNode.getLiteralValue()) instanceof Number) {
            tmpK = ((Number)o).longValue();
        }
        Long k = tmpK;
        Objects.requireNonNull(pathNode);
        Objects.requireNonNull(outNode);
        if (!outNode.isVariable()) {
            throw new RuntimeException("Output node must be a variable");
        }
        Var outVar = (Var)outNode;
        Node sv = argSubject.getArg();
        Node s = sv.isVariable() ? binding.get((Var)sv) : sv;
        ArrayList rdfPaths = new ArrayList();
        String pathStr = pathNode.getLiteralLexicalForm();
        Path path = PathParser.parse((String)pathStr, (Prologue)prologue);
        SparqlKShortestPathFinder pathFinder = this.serviceToPathFinder.apply(ss);
        if (pathFinder == null) {
            logger.info("Falling back on default k shortest path finder service");
            pathFinder = new SparqlKShortestPathFinderMem(ss.getQueryExecutionFactory());
        }
        Iterator<TripletPath<Node, Directed<Node>>> itPaths = pathFinder.findPaths(s, targetNode, path, k);
        Iterable tmp = () -> itPaths;
        Iterator itBindings = StreamSupport.stream(tmp.spliterator(), false).map(p -> {
            Node pNode = NodeFactory.createLiteral((String)("" + p));
            Binding r = BindingFactory.binding((Binding)binding, (Var)outVar, (Node)pNode);
            return r;
        }).iterator();
        QueryIterPlainWrapper result = new QueryIterPlainWrapper(itBindings);
        return result;
    }
}

