/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path2;

import java.util.List;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.sparql_path2.PredicateClass;
import org.aksw.jena_sparql_api.sparql_path2.ValueSet;
import org.aksw.jena_sparql_api.utils.Pair;

public class VertexClass<V>
extends Pair<ValueSet<V>> {
    private static final long serialVersionUID = -3939204124201128789L;

    public static <V> VertexClass<V> union(Pair<ValueSet<V>> a, Pair<ValueSet<V>> b) {
        VertexClass<V> result = VertexClass.merge(a, b, (x, y) -> x.union(y));
        return result;
    }

    public static <V> VertexClass<V> merge(Pair<ValueSet<V>> a, Pair<ValueSet<V>> b, BinaryOperator<ValueSet<V>> op) {
        List<ValueSet<V>> tmp = Stream.of(0, 1).map(i -> {
            ValueSet x = (ValueSet)a.get(i.intValue());
            ValueSet y = (ValueSet)b.get(i.intValue());
            ValueSet r = (ValueSet)op.apply(x, y);
            return r;
        }).collect(Collectors.toList());
        VertexClass<V> result = VertexClass.create(tmp);
        return result;
    }

    public static <V> VertexClass<V> create(List<ValueSet<V>> nodes) {
        VertexClass<V> result = new VertexClass<V>(nodes.get(0), nodes.get(1));
        return result;
    }

    public VertexClass() {
        this(ValueSet.createEmpty(), ValueSet.createEmpty());
    }

    public VertexClass(ValueSet<V> fwdNodes, ValueSet<V> bwdNodes) {
        super(fwdNodes, bwdNodes);
    }

    public ValueSet<V> getFwdNodes() {
        return (ValueSet)this.key;
    }

    public ValueSet<V> getBwdNodes() {
        return (ValueSet)this.value;
    }

    public static PredicateClass reverse(PredicateClass pc) {
        PredicateClass result = new PredicateClass(pc.getBwdNodes(), pc.getFwdNodes());
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : ((ValueSet)this.value).hashCode());
        result = 31 * result + (this.key == null ? 0 : ((ValueSet)this.key).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PredicateClass other = (PredicateClass)((Object)obj);
        if (this.value == null ? other.value != null : !((ValueSet)this.value).equals(other.value)) {
            return false;
        }
        return !(this.key == null ? other.key != null : !((ValueSet)this.key).equals(other.key));
    }

    public String toString() {
        return "[key=" + this.key + ", value=" + this.value + "]";
    }
}

