/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.extra;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.aksw.jena_sparql_api.cache.extra.CacheBackend;
import org.aksw.jena_sparql_api.cache.extra.CacheEntry;
import org.aksw.jena_sparql_api.cache.extra.CacheEntryBase;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;

public class CacheCoreExCompressor
implements CacheBackend {
    private CacheBackend decoratee;
    private final CompressorStreamFactory streamFactory = new CompressorStreamFactory();
    private String compression = "bzip2";

    public CacheCoreExCompressor(CacheBackend decoratee) {
        this.decoratee = decoratee;
    }

    public static CacheCoreExCompressor wrap(CacheBackend decoratee) {
        return new CacheCoreExCompressor(decoratee);
    }

    public CacheEntry wrap(CacheEntry raw) {
        CacheEntryBase result;
        if (raw == null) {
            result = null;
        } else {
            CompressorInputStream in;
            try {
                in = this.streamFactory.createCompressorInputStream(this.compression, raw.getInputStream());
            }
            catch (CompressorException e) {
                throw new RuntimeException(e);
            }
            result = new CacheEntryBase(raw.getTimestamp(), raw.getLifespan(), (InputStream)in);
        }
        return result;
    }

    @Override
    public CacheEntry lookup(String service, String queryString) {
        CacheEntry raw = this.decoratee.lookup(service, queryString);
        return this.wrap(raw);
    }

    @Override
    public void write(String service, String queryString, InputStream in) {
        try {
            this._write(service, queryString, in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void _write(String service, String queryString, InputStream in) throws Exception {
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        CompressorOutputStream out = this.streamFactory.createCompressorOutputStream(this.compression, (OutputStream)tmp);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        PrintWriter writer = new PrintWriter((OutputStream)out);
        byte[] buffer = new byte[1024];
        int n = 0;
        while (-1 != (n = in.read(buffer))) {
            out.write(buffer, 0, n);
        }
        out.flush();
        out.close();
        this.decoratee.write(service, queryString, new ByteArrayInputStream(tmp.toByteArray()));
    }

    public CacheBackend getDecoratee() {
        return this.decoratee;
    }
}

